package zio.aws.appconfig.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.appconfig.model.primitives.{
  Percentage,
  Uri,
  MinutesBetween0And24Hours,
  Iso8601DateTime,
  Description,
  Version,
  Name,
  Id
}
import scala.jdk.CollectionConverters.*
final case class StartDeploymentResponse(
    applicationId: Option[Id] = None,
    environmentId: Option[Id] = None,
    deploymentStrategyId: Option[Id] = None,
    configurationProfileId: Option[Id] = None,
    deploymentNumber: Option[zio.aws.appconfig.model.primitives.Integer] = None,
    configurationName: Option[Name] = None,
    configurationLocationUri: Option[Uri] = None,
    configurationVersion: Option[Version] = None,
    description: Option[Description] = None,
    deploymentDurationInMinutes: Option[MinutesBetween0And24Hours] = None,
    growthType: Option[zio.aws.appconfig.model.GrowthType] = None,
    growthFactor: Option[Percentage] = None,
    finalBakeTimeInMinutes: Option[MinutesBetween0And24Hours] = None,
    state: Option[zio.aws.appconfig.model.DeploymentState] = None,
    eventLog: Option[Iterable[zio.aws.appconfig.model.DeploymentEvent]] = None,
    percentageComplete: Option[Percentage] = None,
    startedAt: Option[Iso8601DateTime] = None,
    completedAt: Option[Iso8601DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.StartDeploymentResponse = {
    import StartDeploymentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.StartDeploymentResponse
      .builder()
      .optionallyWith(
        applicationId.map(value => Id.unwrap(value): java.lang.String)
      )(_.applicationId)
      .optionallyWith(
        environmentId.map(value => Id.unwrap(value): java.lang.String)
      )(_.environmentId)
      .optionallyWith(
        deploymentStrategyId.map(value => Id.unwrap(value): java.lang.String)
      )(_.deploymentStrategyId)
      .optionallyWith(
        configurationProfileId.map(value => Id.unwrap(value): java.lang.String)
      )(_.configurationProfileId)
      .optionallyWith(deploymentNumber.map(value => value: Integer))(
        _.deploymentNumber
      )
      .optionallyWith(
        configurationName.map(value => Name.unwrap(value): java.lang.String)
      )(_.configurationName)
      .optionallyWith(
        configurationLocationUri.map(value =>
          Uri.unwrap(value): java.lang.String
        )
      )(_.configurationLocationUri)
      .optionallyWith(
        configurationVersion.map(value =>
          Version.unwrap(value): java.lang.String
        )
      )(_.configurationVersion)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        deploymentDurationInMinutes.map(value =>
          MinutesBetween0And24Hours.unwrap(value): Integer
        )
      )(_.deploymentDurationInMinutes)
      .optionallyWith(growthType.map(value => value.unwrap))(_.growthType)
      .optionallyWith(
        growthFactor.map(value => Percentage.unwrap(value): java.lang.Float)
      )(_.growthFactor)
      .optionallyWith(
        finalBakeTimeInMinutes.map(value =>
          MinutesBetween0And24Hours.unwrap(value): Integer
        )
      )(_.finalBakeTimeInMinutes)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        eventLog.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventLog)
      .optionallyWith(
        percentageComplete.map(value =>
          Percentage.unwrap(value): java.lang.Float
        )
      )(_.percentageComplete)
      .optionallyWith(
        startedAt.map(value => Iso8601DateTime.unwrap(value): Instant)
      )(_.startedAt)
      .optionallyWith(
        completedAt.map(value => Iso8601DateTime.unwrap(value): Instant)
      )(_.completedAt)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.StartDeploymentResponse.ReadOnly =
    zio.aws.appconfig.model.StartDeploymentResponse.wrap(buildAwsValue())
}
object StartDeploymentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.StartDeploymentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.StartDeploymentResponse =
      zio.aws.appconfig.model.StartDeploymentResponse(
        applicationId.map(value => value),
        environmentId.map(value => value),
        deploymentStrategyId.map(value => value),
        configurationProfileId.map(value => value),
        deploymentNumber.map(value => value),
        configurationName.map(value => value),
        configurationLocationUri.map(value => value),
        configurationVersion.map(value => value),
        description.map(value => value),
        deploymentDurationInMinutes.map(value => value),
        growthType.map(value => value),
        growthFactor.map(value => value),
        finalBakeTimeInMinutes.map(value => value),
        state.map(value => value),
        eventLog.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        percentageComplete.map(value => value),
        startedAt.map(value => value),
        completedAt.map(value => value)
      )
    def applicationId: Option[Id]
    def environmentId: Option[Id]
    def deploymentStrategyId: Option[Id]
    def configurationProfileId: Option[Id]
    def deploymentNumber: Option[zio.aws.appconfig.model.primitives.Integer]
    def configurationName: Option[Name]
    def configurationLocationUri: Option[Uri]
    def configurationVersion: Option[Version]
    def description: Option[Description]
    def deploymentDurationInMinutes: Option[MinutesBetween0And24Hours]
    def growthType: Option[zio.aws.appconfig.model.GrowthType]
    def growthFactor: Option[Percentage]
    def finalBakeTimeInMinutes: Option[MinutesBetween0And24Hours]
    def state: Option[zio.aws.appconfig.model.DeploymentState]
    def eventLog: Option[List[zio.aws.appconfig.model.DeploymentEvent.ReadOnly]]
    def percentageComplete: Option[Percentage]
    def startedAt: Option[Iso8601DateTime]
    def completedAt: Option[Iso8601DateTime]
    def getApplicationId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getEnvironmentId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getDeploymentStrategyId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("deploymentStrategyId", deploymentStrategyId)
    def getConfigurationProfileId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("configurationProfileId", configurationProfileId)
    def getDeploymentNumber
        : ZIO[Any, AwsError, zio.aws.appconfig.model.primitives.Integer] =
      AwsError.unwrapOptionField("deploymentNumber", deploymentNumber)
    def getConfigurationName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("configurationName", configurationName)
    def getConfigurationLocationUri: ZIO[Any, AwsError, Uri] = AwsError
      .unwrapOptionField("configurationLocationUri", configurationLocationUri)
    def getConfigurationVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("configurationVersion", configurationVersion)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDeploymentDurationInMinutes
        : ZIO[Any, AwsError, MinutesBetween0And24Hours] =
      AwsError.unwrapOptionField(
        "deploymentDurationInMinutes",
        deploymentDurationInMinutes
      )
    def getGrowthType: ZIO[Any, AwsError, zio.aws.appconfig.model.GrowthType] =
      AwsError.unwrapOptionField("growthType", growthType)
    def getGrowthFactor: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("growthFactor", growthFactor)
    def getFinalBakeTimeInMinutes
        : ZIO[Any, AwsError, MinutesBetween0And24Hours] = AwsError
      .unwrapOptionField("finalBakeTimeInMinutes", finalBakeTimeInMinutes)
    def getState: ZIO[Any, AwsError, zio.aws.appconfig.model.DeploymentState] =
      AwsError.unwrapOptionField("state", state)
    def getEventLog: ZIO[Any, AwsError, List[
      zio.aws.appconfig.model.DeploymentEvent.ReadOnly
    ]] = AwsError.unwrapOptionField("eventLog", eventLog)
    def getPercentageComplete: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("percentageComplete", percentageComplete)
    def getStartedAt: ZIO[Any, AwsError, Iso8601DateTime] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getCompletedAt: ZIO[Any, AwsError, Iso8601DateTime] =
      AwsError.unwrapOptionField("completedAt", completedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.StartDeploymentResponse
  ) extends zio.aws.appconfig.model.StartDeploymentResponse.ReadOnly {
    override val applicationId: Option[Id] = scala
      .Option(impl.applicationId())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val environmentId: Option[Id] = scala
      .Option(impl.environmentId())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val deploymentStrategyId: Option[Id] = scala
      .Option(impl.deploymentStrategyId())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val configurationProfileId: Option[Id] = scala
      .Option(impl.configurationProfileId())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val deploymentNumber
        : Option[zio.aws.appconfig.model.primitives.Integer] = scala
      .Option(impl.deploymentNumber())
      .map(value => value: zio.aws.appconfig.model.primitives.Integer)
    override val configurationName: Option[Name] = scala
      .Option(impl.configurationName())
      .map(value => zio.aws.appconfig.model.primitives.Name(value))
    override val configurationLocationUri: Option[Uri] = scala
      .Option(impl.configurationLocationUri())
      .map(value => zio.aws.appconfig.model.primitives.Uri(value))
    override val configurationVersion: Option[Version] = scala
      .Option(impl.configurationVersion())
      .map(value => zio.aws.appconfig.model.primitives.Version(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val deploymentDurationInMinutes
        : Option[MinutesBetween0And24Hours] = scala
      .Option(impl.deploymentDurationInMinutes())
      .map(value =>
        zio.aws.appconfig.model.primitives.MinutesBetween0And24Hours(value)
      )
    override val growthType: Option[zio.aws.appconfig.model.GrowthType] = scala
      .Option(impl.growthType())
      .map(value => zio.aws.appconfig.model.GrowthType.wrap(value))
    override val growthFactor: Option[Percentage] = scala
      .Option(impl.growthFactor())
      .map(value => zio.aws.appconfig.model.primitives.Percentage(value))
    override val finalBakeTimeInMinutes: Option[MinutesBetween0And24Hours] =
      scala
        .Option(impl.finalBakeTimeInMinutes())
        .map(value =>
          zio.aws.appconfig.model.primitives.MinutesBetween0And24Hours(value)
        )
    override val state: Option[zio.aws.appconfig.model.DeploymentState] = scala
      .Option(impl.state())
      .map(value => zio.aws.appconfig.model.DeploymentState.wrap(value))
    override val eventLog
        : Option[List[zio.aws.appconfig.model.DeploymentEvent.ReadOnly]] = scala
      .Option(impl.eventLog())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appconfig.model.DeploymentEvent.wrap(item)
        }.toList
      )
    override val percentageComplete: Option[Percentage] = scala
      .Option(impl.percentageComplete())
      .map(value => zio.aws.appconfig.model.primitives.Percentage(value))
    override val startedAt: Option[Iso8601DateTime] = scala
      .Option(impl.startedAt())
      .map(value => zio.aws.appconfig.model.primitives.Iso8601DateTime(value))
    override val completedAt: Option[Iso8601DateTime] = scala
      .Option(impl.completedAt())
      .map(value => zio.aws.appconfig.model.primitives.Iso8601DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.StartDeploymentResponse
  ): zio.aws.appconfig.model.StartDeploymentResponse.ReadOnly = new Wrapper(
    impl
  )
}
