package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{TagValue, TagKey, Arn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: Arn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.TagResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.TagResourceRequest.ReadOnly =
    zio.aws.appconfig.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.TagResourceRequest =
      zio.aws.appconfig.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: Arn
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.TagResourceRequest
  ) extends zio.aws.appconfig.model.TagResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.appconfig.model.primitives.Arn(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.appconfig.model.primitives
          .TagKey(key) -> zio.aws.appconfig.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.TagResourceRequest
  ): zio.aws.appconfig.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
