package zio.aws.appconfig.model
import scala.jdk.CollectionConverters.*
sealed trait TriggeredBy {
  def unwrap: software.amazon.awssdk.services.appconfig.model.TriggeredBy
}
object TriggeredBy {
  def wrap(
      value: software.amazon.awssdk.services.appconfig.model.TriggeredBy
  ): zio.aws.appconfig.model.TriggeredBy = value match {
    case software.amazon.awssdk.services.appconfig.model.TriggeredBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appconfig.model.TriggeredBy.USER =>
      val r = USER
      r
    case software.amazon.awssdk.services.appconfig.model.TriggeredBy.APPCONFIG =>
      val r = APPCONFIG
      r
    case software.amazon.awssdk.services.appconfig.model.TriggeredBy.CLOUDWATCH_ALARM =>
      val r = CLOUDWATCH_ALARM
      r
    case software.amazon.awssdk.services.appconfig.model.TriggeredBy.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
  }
  case object unknownToSdkVersion extends zio.aws.appconfig.model.TriggeredBy {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.TriggeredBy =
      software.amazon.awssdk.services.appconfig.model.TriggeredBy.UNKNOWN_TO_SDK_VERSION
  }
  case object USER extends zio.aws.appconfig.model.TriggeredBy {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.TriggeredBy =
      software.amazon.awssdk.services.appconfig.model.TriggeredBy.USER
  }
  case object APPCONFIG extends zio.aws.appconfig.model.TriggeredBy {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.TriggeredBy =
      software.amazon.awssdk.services.appconfig.model.TriggeredBy.APPCONFIG
  }
  case object CLOUDWATCH_ALARM extends zio.aws.appconfig.model.TriggeredBy {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.TriggeredBy =
      software.amazon.awssdk.services.appconfig.model.TriggeredBy.CLOUDWATCH_ALARM
  }
  case object INTERNAL_ERROR extends zio.aws.appconfig.model.TriggeredBy {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.TriggeredBy =
      software.amazon.awssdk.services.appconfig.model.TriggeredBy.INTERNAL_ERROR
  }
}
