package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{Description, Name, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateApplicationRequest(
    applicationId: Id,
    name: Option[Name] = None,
    description: Option[Description] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.UpdateApplicationRequest = {
    import UpdateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.UpdateApplicationRequest
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.UpdateApplicationRequest.ReadOnly =
    zio.aws.appconfig.model.UpdateApplicationRequest.wrap(buildAwsValue())
}
object UpdateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.UpdateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.UpdateApplicationRequest =
      zio.aws.appconfig.model.UpdateApplicationRequest(
        applicationId,
        name.map(value => value),
        description.map(value => value)
      )
    def applicationId: Id
    def name: Option[Name]
    def description: Option[Description]
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.UpdateApplicationRequest
  ) extends zio.aws.appconfig.model.UpdateApplicationRequest.ReadOnly {
    override val applicationId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.applicationId())
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.appconfig.model.primitives.Name(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.UpdateApplicationRequest
  ): zio.aws.appconfig.model.UpdateApplicationRequest.ReadOnly = new Wrapper(
    impl
  )
}
