package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{
  RoleArn,
  ConfigurationProfileType,
  Uri,
  Description,
  Name,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateConfigurationProfileResponse(
    applicationId: Option[Id] = None,
    id: Option[Id] = None,
    name: Option[Name] = None,
    description: Option[Description] = None,
    locationUri: Option[Uri] = None,
    retrievalRoleArn: Option[RoleArn] = None,
    validators: Option[Iterable[zio.aws.appconfig.model.Validator]] = None,
    `type`: Option[ConfigurationProfileType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.UpdateConfigurationProfileResponse = {
    import UpdateConfigurationProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.UpdateConfigurationProfileResponse
      .builder()
      .optionallyWith(
        applicationId.map(value => Id.unwrap(value): java.lang.String)
      )(_.applicationId)
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        locationUri.map(value => Uri.unwrap(value): java.lang.String)
      )(_.locationUri)
      .optionallyWith(
        retrievalRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.retrievalRoleArn)
      .optionallyWith(
        validators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validators)
      .optionallyWith(
        `type`.map(value =>
          ConfigurationProfileType.unwrap(value): java.lang.String
        )
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.UpdateConfigurationProfileResponse.ReadOnly =
    zio.aws.appconfig.model.UpdateConfigurationProfileResponse
      .wrap(buildAwsValue())
}
object UpdateConfigurationProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.UpdateConfigurationProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.UpdateConfigurationProfileResponse =
      zio.aws.appconfig.model.UpdateConfigurationProfileResponse(
        applicationId.map(value => value),
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        locationUri.map(value => value),
        retrievalRoleArn.map(value => value),
        validators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        `type`.map(value => value)
      )
    def applicationId: Option[Id]
    def id: Option[Id]
    def name: Option[Name]
    def description: Option[Description]
    def locationUri: Option[Uri]
    def retrievalRoleArn: Option[RoleArn]
    def validators: Option[List[zio.aws.appconfig.model.Validator.ReadOnly]]
    def `type`: Option[ConfigurationProfileType]
    def getApplicationId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLocationUri: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("locationUri", locationUri)
    def getRetrievalRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("retrievalRoleArn", retrievalRoleArn)
    def getValidators
        : ZIO[Any, AwsError, List[zio.aws.appconfig.model.Validator.ReadOnly]] =
      AwsError.unwrapOptionField("validators", validators)
    def getType: ZIO[Any, AwsError, ConfigurationProfileType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.UpdateConfigurationProfileResponse
  ) extends zio.aws.appconfig.model.UpdateConfigurationProfileResponse.ReadOnly {
    override val applicationId: Option[Id] = scala
      .Option(impl.applicationId())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val id: Option[Id] = scala
      .Option(impl.id())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.appconfig.model.primitives.Name(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val locationUri: Option[Uri] = scala
      .Option(impl.locationUri())
      .map(value => zio.aws.appconfig.model.primitives.Uri(value))
    override val retrievalRoleArn: Option[RoleArn] = scala
      .Option(impl.retrievalRoleArn())
      .map(value => zio.aws.appconfig.model.primitives.RoleArn(value))
    override val validators
        : Option[List[zio.aws.appconfig.model.Validator.ReadOnly]] = scala
      .Option(impl.validators())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appconfig.model.Validator.wrap(item)
        }.toList
      )
    override val `type`: Option[ConfigurationProfileType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.appconfig.model.primitives.ConfigurationProfileType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.UpdateConfigurationProfileResponse
  ): zio.aws.appconfig.model.UpdateConfigurationProfileResponse.ReadOnly =
    new Wrapper(impl)
}
