package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{
  GrowthFactor,
  MinutesBetween0And24Hours,
  Description,
  DeploymentStrategyId
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateDeploymentStrategyRequest(
    deploymentStrategyId: DeploymentStrategyId,
    description: Option[Description] = None,
    deploymentDurationInMinutes: Option[MinutesBetween0And24Hours] = None,
    finalBakeTimeInMinutes: Option[MinutesBetween0And24Hours] = None,
    growthFactor: Option[GrowthFactor] = None,
    growthType: Option[zio.aws.appconfig.model.GrowthType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.UpdateDeploymentStrategyRequest = {
    import UpdateDeploymentStrategyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.UpdateDeploymentStrategyRequest
      .builder()
      .deploymentStrategyId(
        DeploymentStrategyId.unwrap(deploymentStrategyId): java.lang.String
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        deploymentDurationInMinutes.map(value =>
          MinutesBetween0And24Hours.unwrap(value): Integer
        )
      )(_.deploymentDurationInMinutes)
      .optionallyWith(
        finalBakeTimeInMinutes.map(value =>
          MinutesBetween0And24Hours.unwrap(value): Integer
        )
      )(_.finalBakeTimeInMinutes)
      .optionallyWith(
        growthFactor.map(value => GrowthFactor.unwrap(value): java.lang.Float)
      )(_.growthFactor)
      .optionallyWith(growthType.map(value => value.unwrap))(_.growthType)
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.UpdateDeploymentStrategyRequest.ReadOnly =
    zio.aws.appconfig.model.UpdateDeploymentStrategyRequest
      .wrap(buildAwsValue())
}
object UpdateDeploymentStrategyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.UpdateDeploymentStrategyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.UpdateDeploymentStrategyRequest =
      zio.aws.appconfig.model.UpdateDeploymentStrategyRequest(
        deploymentStrategyId,
        description.map(value => value),
        deploymentDurationInMinutes.map(value => value),
        finalBakeTimeInMinutes.map(value => value),
        growthFactor.map(value => value),
        growthType.map(value => value)
      )
    def deploymentStrategyId: DeploymentStrategyId
    def description: Option[Description]
    def deploymentDurationInMinutes: Option[MinutesBetween0And24Hours]
    def finalBakeTimeInMinutes: Option[MinutesBetween0And24Hours]
    def growthFactor: Option[GrowthFactor]
    def growthType: Option[zio.aws.appconfig.model.GrowthType]
    def getDeploymentStrategyId: ZIO[Any, Nothing, DeploymentStrategyId] =
      ZIO.succeed(deploymentStrategyId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDeploymentDurationInMinutes
        : ZIO[Any, AwsError, MinutesBetween0And24Hours] =
      AwsError.unwrapOptionField(
        "deploymentDurationInMinutes",
        deploymentDurationInMinutes
      )
    def getFinalBakeTimeInMinutes
        : ZIO[Any, AwsError, MinutesBetween0And24Hours] = AwsError
      .unwrapOptionField("finalBakeTimeInMinutes", finalBakeTimeInMinutes)
    def getGrowthFactor: ZIO[Any, AwsError, GrowthFactor] =
      AwsError.unwrapOptionField("growthFactor", growthFactor)
    def getGrowthType: ZIO[Any, AwsError, zio.aws.appconfig.model.GrowthType] =
      AwsError.unwrapOptionField("growthType", growthType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.UpdateDeploymentStrategyRequest
  ) extends zio.aws.appconfig.model.UpdateDeploymentStrategyRequest.ReadOnly {
    override val deploymentStrategyId: DeploymentStrategyId =
      zio.aws.appconfig.model.primitives
        .DeploymentStrategyId(impl.deploymentStrategyId())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val deploymentDurationInMinutes
        : Option[MinutesBetween0And24Hours] = scala
      .Option(impl.deploymentDurationInMinutes())
      .map(value =>
        zio.aws.appconfig.model.primitives.MinutesBetween0And24Hours(value)
      )
    override val finalBakeTimeInMinutes: Option[MinutesBetween0And24Hours] =
      scala
        .Option(impl.finalBakeTimeInMinutes())
        .map(value =>
          zio.aws.appconfig.model.primitives.MinutesBetween0And24Hours(value)
        )
    override val growthFactor: Option[GrowthFactor] = scala
      .Option(impl.growthFactor())
      .map(value => zio.aws.appconfig.model.primitives.GrowthFactor(value))
    override val growthType: Option[zio.aws.appconfig.model.GrowthType] = scala
      .Option(impl.growthType())
      .map(value => zio.aws.appconfig.model.GrowthType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.UpdateDeploymentStrategyRequest
  ): zio.aws.appconfig.model.UpdateDeploymentStrategyRequest.ReadOnly =
    new Wrapper(impl)
}
