package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{
  Percentage,
  MinutesBetween0And24Hours,
  Description,
  Name,
  Id
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateDeploymentStrategyResponse(
    id: Option[Id] = None,
    name: Option[Name] = None,
    description: Option[Description] = None,
    deploymentDurationInMinutes: Option[MinutesBetween0And24Hours] = None,
    growthType: Option[zio.aws.appconfig.model.GrowthType] = None,
    growthFactor: Option[Percentage] = None,
    finalBakeTimeInMinutes: Option[MinutesBetween0And24Hours] = None,
    replicateTo: Option[zio.aws.appconfig.model.ReplicateTo] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.UpdateDeploymentStrategyResponse = {
    import UpdateDeploymentStrategyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.UpdateDeploymentStrategyResponse
      .builder()
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        deploymentDurationInMinutes.map(value =>
          MinutesBetween0And24Hours.unwrap(value): Integer
        )
      )(_.deploymentDurationInMinutes)
      .optionallyWith(growthType.map(value => value.unwrap))(_.growthType)
      .optionallyWith(
        growthFactor.map(value => Percentage.unwrap(value): java.lang.Float)
      )(_.growthFactor)
      .optionallyWith(
        finalBakeTimeInMinutes.map(value =>
          MinutesBetween0And24Hours.unwrap(value): Integer
        )
      )(_.finalBakeTimeInMinutes)
      .optionallyWith(replicateTo.map(value => value.unwrap))(_.replicateTo)
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.UpdateDeploymentStrategyResponse.ReadOnly =
    zio.aws.appconfig.model.UpdateDeploymentStrategyResponse
      .wrap(buildAwsValue())
}
object UpdateDeploymentStrategyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.UpdateDeploymentStrategyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.UpdateDeploymentStrategyResponse =
      zio.aws.appconfig.model.UpdateDeploymentStrategyResponse(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        deploymentDurationInMinutes.map(value => value),
        growthType.map(value => value),
        growthFactor.map(value => value),
        finalBakeTimeInMinutes.map(value => value),
        replicateTo.map(value => value)
      )
    def id: Option[Id]
    def name: Option[Name]
    def description: Option[Description]
    def deploymentDurationInMinutes: Option[MinutesBetween0And24Hours]
    def growthType: Option[zio.aws.appconfig.model.GrowthType]
    def growthFactor: Option[Percentage]
    def finalBakeTimeInMinutes: Option[MinutesBetween0And24Hours]
    def replicateTo: Option[zio.aws.appconfig.model.ReplicateTo]
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDeploymentDurationInMinutes
        : ZIO[Any, AwsError, MinutesBetween0And24Hours] =
      AwsError.unwrapOptionField(
        "deploymentDurationInMinutes",
        deploymentDurationInMinutes
      )
    def getGrowthType: ZIO[Any, AwsError, zio.aws.appconfig.model.GrowthType] =
      AwsError.unwrapOptionField("growthType", growthType)
    def getGrowthFactor: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("growthFactor", growthFactor)
    def getFinalBakeTimeInMinutes
        : ZIO[Any, AwsError, MinutesBetween0And24Hours] = AwsError
      .unwrapOptionField("finalBakeTimeInMinutes", finalBakeTimeInMinutes)
    def getReplicateTo
        : ZIO[Any, AwsError, zio.aws.appconfig.model.ReplicateTo] =
      AwsError.unwrapOptionField("replicateTo", replicateTo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.UpdateDeploymentStrategyResponse
  ) extends zio.aws.appconfig.model.UpdateDeploymentStrategyResponse.ReadOnly {
    override val id: Option[Id] = scala
      .Option(impl.id())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.appconfig.model.primitives.Name(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val deploymentDurationInMinutes
        : Option[MinutesBetween0And24Hours] = scala
      .Option(impl.deploymentDurationInMinutes())
      .map(value =>
        zio.aws.appconfig.model.primitives.MinutesBetween0And24Hours(value)
      )
    override val growthType: Option[zio.aws.appconfig.model.GrowthType] = scala
      .Option(impl.growthType())
      .map(value => zio.aws.appconfig.model.GrowthType.wrap(value))
    override val growthFactor: Option[Percentage] = scala
      .Option(impl.growthFactor())
      .map(value => zio.aws.appconfig.model.primitives.Percentage(value))
    override val finalBakeTimeInMinutes: Option[MinutesBetween0And24Hours] =
      scala
        .Option(impl.finalBakeTimeInMinutes())
        .map(value =>
          zio.aws.appconfig.model.primitives.MinutesBetween0And24Hours(value)
        )
    override val replicateTo: Option[zio.aws.appconfig.model.ReplicateTo] =
      scala
        .Option(impl.replicateTo())
        .map(value => zio.aws.appconfig.model.ReplicateTo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.UpdateDeploymentStrategyResponse
  ): zio.aws.appconfig.model.UpdateDeploymentStrategyResponse.ReadOnly =
    new Wrapper(impl)
}
