package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{Version, Id}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ValidateConfigurationRequest(
    applicationId: Id,
    configurationProfileId: Id,
    configurationVersion: Version
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.ValidateConfigurationRequest = {
    import ValidateConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.ValidateConfigurationRequest
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .configurationProfileId(
        Id.unwrap(configurationProfileId): java.lang.String
      )
      .configurationVersion(
        Version.unwrap(configurationVersion): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.ValidateConfigurationRequest.ReadOnly =
    zio.aws.appconfig.model.ValidateConfigurationRequest.wrap(buildAwsValue())
}
object ValidateConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.ValidateConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.ValidateConfigurationRequest =
      zio.aws.appconfig.model.ValidateConfigurationRequest(
        applicationId,
        configurationProfileId,
        configurationVersion
      )
    def applicationId: Id
    def configurationProfileId: Id
    def configurationVersion: Version
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
    def getConfigurationProfileId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(configurationProfileId)
    def getConfigurationVersion: ZIO[Any, Nothing, Version] =
      ZIO.succeed(configurationVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.ValidateConfigurationRequest
  ) extends zio.aws.appconfig.model.ValidateConfigurationRequest.ReadOnly {
    override val applicationId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.applicationId())
    override val configurationProfileId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.configurationProfileId())
    override val configurationVersion: Version =
      zio.aws.appconfig.model.primitives.Version(impl.configurationVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.ValidateConfigurationRequest
  ): zio.aws.appconfig.model.ValidateConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
