package zio.aws.appconfig.model
import scala.jdk.CollectionConverters.*
sealed trait ValidatorType {
  def unwrap: software.amazon.awssdk.services.appconfig.model.ValidatorType
}
object ValidatorType {
  def wrap(
      value: software.amazon.awssdk.services.appconfig.model.ValidatorType
  ): zio.aws.appconfig.model.ValidatorType = value match {
    case software.amazon.awssdk.services.appconfig.model.ValidatorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appconfig.model.ValidatorType.JSON_SCHEMA =>
      val r = JSON_SCHEMA
      r
    case software.amazon.awssdk.services.appconfig.model.ValidatorType.LAMBDA =>
      val r = LAMBDA
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appconfig.model.ValidatorType {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.ValidatorType =
      software.amazon.awssdk.services.appconfig.model.ValidatorType.UNKNOWN_TO_SDK_VERSION
  }
  case object JSON_SCHEMA extends zio.aws.appconfig.model.ValidatorType {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.ValidatorType =
      software.amazon.awssdk.services.appconfig.model.ValidatorType.JSON_SCHEMA
  }
  case object LAMBDA extends zio.aws.appconfig.model.ValidatorType {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.ValidatorType =
      software.amazon.awssdk.services.appconfig.model.ValidatorType.LAMBDA
  }
}
