package zio.aws.appconfig.model
import scala.jdk.CollectionConverters.*
sealed trait DeploymentEventType {
  def unwrap
      : software.amazon.awssdk.services.appconfig.model.DeploymentEventType
}
object DeploymentEventType {
  def wrap(
      value: software.amazon.awssdk.services.appconfig.model.DeploymentEventType
  ): zio.aws.appconfig.model.DeploymentEventType = value match {
    case software.amazon.awssdk.services.appconfig.model.DeploymentEventType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appconfig.model.DeploymentEventType.PERCENTAGE_UPDATED =>
      val r = PERCENTAGE_UPDATED
      r
    case software.amazon.awssdk.services.appconfig.model.DeploymentEventType.ROLLBACK_STARTED =>
      val r = ROLLBACK_STARTED
      r
    case software.amazon.awssdk.services.appconfig.model.DeploymentEventType.ROLLBACK_COMPLETED =>
      val r = ROLLBACK_COMPLETED
      r
    case software.amazon.awssdk.services.appconfig.model.DeploymentEventType.BAKE_TIME_STARTED =>
      val r = BAKE_TIME_STARTED
      r
    case software.amazon.awssdk.services.appconfig.model.DeploymentEventType.DEPLOYMENT_STARTED =>
      val r = DEPLOYMENT_STARTED
      r
    case software.amazon.awssdk.services.appconfig.model.DeploymentEventType.DEPLOYMENT_COMPLETED =>
      val r = DEPLOYMENT_COMPLETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appconfig.model.DeploymentEventType {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.DeploymentEventType =
      software.amazon.awssdk.services.appconfig.model.DeploymentEventType.UNKNOWN_TO_SDK_VERSION
  }
  case object PERCENTAGE_UPDATED
      extends zio.aws.appconfig.model.DeploymentEventType {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.DeploymentEventType =
      software.amazon.awssdk.services.appconfig.model.DeploymentEventType.PERCENTAGE_UPDATED
  }
  case object ROLLBACK_STARTED
      extends zio.aws.appconfig.model.DeploymentEventType {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.DeploymentEventType =
      software.amazon.awssdk.services.appconfig.model.DeploymentEventType.ROLLBACK_STARTED
  }
  case object ROLLBACK_COMPLETED
      extends zio.aws.appconfig.model.DeploymentEventType {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.DeploymentEventType =
      software.amazon.awssdk.services.appconfig.model.DeploymentEventType.ROLLBACK_COMPLETED
  }
  case object BAKE_TIME_STARTED
      extends zio.aws.appconfig.model.DeploymentEventType {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.DeploymentEventType =
      software.amazon.awssdk.services.appconfig.model.DeploymentEventType.BAKE_TIME_STARTED
  }
  case object DEPLOYMENT_STARTED
      extends zio.aws.appconfig.model.DeploymentEventType {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.DeploymentEventType =
      software.amazon.awssdk.services.appconfig.model.DeploymentEventType.DEPLOYMENT_STARTED
  }
  case object DEPLOYMENT_COMPLETED
      extends zio.aws.appconfig.model.DeploymentEventType {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.DeploymentEventType =
      software.amazon.awssdk.services.appconfig.model.DeploymentEventType.DEPLOYMENT_COMPLETED
  }
}
