package zio.aws.appconfig.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.appconfig.model.primitives.{
  Percentage,
  MinutesBetween0And24Hours,
  Iso8601DateTime,
  Version,
  Name
}
import scala.jdk.CollectionConverters.*
final case class DeploymentSummary(
    deploymentNumber: Optional[zio.aws.appconfig.model.primitives.Integer] =
      Optional.Absent,
    configurationName: Optional[Name] = Optional.Absent,
    configurationVersion: Optional[Version] = Optional.Absent,
    deploymentDurationInMinutes: Optional[MinutesBetween0And24Hours] =
      Optional.Absent,
    growthType: Optional[zio.aws.appconfig.model.GrowthType] = Optional.Absent,
    growthFactor: Optional[Percentage] = Optional.Absent,
    finalBakeTimeInMinutes: Optional[MinutesBetween0And24Hours] =
      Optional.Absent,
    state: Optional[zio.aws.appconfig.model.DeploymentState] = Optional.Absent,
    percentageComplete: Optional[Percentage] = Optional.Absent,
    startedAt: Optional[Iso8601DateTime] = Optional.Absent,
    completedAt: Optional[Iso8601DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.DeploymentSummary = {
    import DeploymentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.DeploymentSummary
      .builder()
      .optionallyWith(deploymentNumber.map(value => value: Integer))(
        _.deploymentNumber
      )
      .optionallyWith(
        configurationName.map(value => Name.unwrap(value): java.lang.String)
      )(_.configurationName)
      .optionallyWith(
        configurationVersion.map(value =>
          Version.unwrap(value): java.lang.String
        )
      )(_.configurationVersion)
      .optionallyWith(
        deploymentDurationInMinutes.map(value =>
          MinutesBetween0And24Hours.unwrap(value): Integer
        )
      )(_.deploymentDurationInMinutes)
      .optionallyWith(growthType.map(value => value.unwrap))(_.growthType)
      .optionallyWith(
        growthFactor.map(value => Percentage.unwrap(value): java.lang.Float)
      )(_.growthFactor)
      .optionallyWith(
        finalBakeTimeInMinutes.map(value =>
          MinutesBetween0And24Hours.unwrap(value): Integer
        )
      )(_.finalBakeTimeInMinutes)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        percentageComplete.map(value =>
          Percentage.unwrap(value): java.lang.Float
        )
      )(_.percentageComplete)
      .optionallyWith(
        startedAt.map(value => Iso8601DateTime.unwrap(value): Instant)
      )(_.startedAt)
      .optionallyWith(
        completedAt.map(value => Iso8601DateTime.unwrap(value): Instant)
      )(_.completedAt)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.DeploymentSummary.ReadOnly =
    zio.aws.appconfig.model.DeploymentSummary.wrap(buildAwsValue())
}
object DeploymentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.DeploymentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.DeploymentSummary =
      zio.aws.appconfig.model.DeploymentSummary(
        deploymentNumber.map(value => value),
        configurationName.map(value => value),
        configurationVersion.map(value => value),
        deploymentDurationInMinutes.map(value => value),
        growthType.map(value => value),
        growthFactor.map(value => value),
        finalBakeTimeInMinutes.map(value => value),
        state.map(value => value),
        percentageComplete.map(value => value),
        startedAt.map(value => value),
        completedAt.map(value => value)
      )
    def deploymentNumber: Optional[zio.aws.appconfig.model.primitives.Integer]
    def configurationName: Optional[Name]
    def configurationVersion: Optional[Version]
    def deploymentDurationInMinutes: Optional[MinutesBetween0And24Hours]
    def growthType: Optional[zio.aws.appconfig.model.GrowthType]
    def growthFactor: Optional[Percentage]
    def finalBakeTimeInMinutes: Optional[MinutesBetween0And24Hours]
    def state: Optional[zio.aws.appconfig.model.DeploymentState]
    def percentageComplete: Optional[Percentage]
    def startedAt: Optional[Iso8601DateTime]
    def completedAt: Optional[Iso8601DateTime]
    def getDeploymentNumber
        : ZIO[Any, AwsError, zio.aws.appconfig.model.primitives.Integer] =
      AwsError.unwrapOptionField("deploymentNumber", deploymentNumber)
    def getConfigurationName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("configurationName", configurationName)
    def getConfigurationVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("configurationVersion", configurationVersion)
    def getDeploymentDurationInMinutes
        : ZIO[Any, AwsError, MinutesBetween0And24Hours] =
      AwsError.unwrapOptionField(
        "deploymentDurationInMinutes",
        deploymentDurationInMinutes
      )
    def getGrowthType: ZIO[Any, AwsError, zio.aws.appconfig.model.GrowthType] =
      AwsError.unwrapOptionField("growthType", growthType)
    def getGrowthFactor: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("growthFactor", growthFactor)
    def getFinalBakeTimeInMinutes
        : ZIO[Any, AwsError, MinutesBetween0And24Hours] = AwsError
      .unwrapOptionField("finalBakeTimeInMinutes", finalBakeTimeInMinutes)
    def getState: ZIO[Any, AwsError, zio.aws.appconfig.model.DeploymentState] =
      AwsError.unwrapOptionField("state", state)
    def getPercentageComplete: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("percentageComplete", percentageComplete)
    def getStartedAt: ZIO[Any, AwsError, Iso8601DateTime] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getCompletedAt: ZIO[Any, AwsError, Iso8601DateTime] =
      AwsError.unwrapOptionField("completedAt", completedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.DeploymentSummary
  ) extends zio.aws.appconfig.model.DeploymentSummary.ReadOnly {
    override val deploymentNumber
        : Optional[zio.aws.appconfig.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentNumber())
        .map(value => value: zio.aws.appconfig.model.primitives.Integer)
    override val configurationName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationName())
      .map(value => zio.aws.appconfig.model.primitives.Name(value))
    override val configurationVersion: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationVersion())
      .map(value => zio.aws.appconfig.model.primitives.Version(value))
    override val deploymentDurationInMinutes
        : Optional[MinutesBetween0And24Hours] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentDurationInMinutes())
      .map(value =>
        zio.aws.appconfig.model.primitives.MinutesBetween0And24Hours(value)
      )
    override val growthType: Optional[zio.aws.appconfig.model.GrowthType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.growthType())
        .map(value => zio.aws.appconfig.model.GrowthType.wrap(value))
    override val growthFactor: Optional[Percentage] = zio.aws.core.internal
      .optionalFromNullable(impl.growthFactor())
      .map(value => zio.aws.appconfig.model.primitives.Percentage(value))
    override val finalBakeTimeInMinutes: Optional[MinutesBetween0And24Hours] =
      zio.aws.core.internal
        .optionalFromNullable(impl.finalBakeTimeInMinutes())
        .map(value =>
          zio.aws.appconfig.model.primitives.MinutesBetween0And24Hours(value)
        )
    override val state: Optional[zio.aws.appconfig.model.DeploymentState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.appconfig.model.DeploymentState.wrap(value))
    override val percentageComplete: Optional[Percentage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.percentageComplete())
        .map(value => zio.aws.appconfig.model.primitives.Percentage(value))
    override val startedAt: Optional[Iso8601DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.appconfig.model.primitives.Iso8601DateTime(value))
    override val completedAt: Optional[Iso8601DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.completedAt())
      .map(value => zio.aws.appconfig.model.primitives.Iso8601DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.DeploymentSummary
  ): zio.aws.appconfig.model.DeploymentSummary.ReadOnly = new Wrapper(impl)
}
