package zio.aws.appconfig.model
import scala.jdk.CollectionConverters.*
sealed trait ReplicateTo {
  def unwrap: software.amazon.awssdk.services.appconfig.model.ReplicateTo
}
object ReplicateTo {
  def wrap(
      value: software.amazon.awssdk.services.appconfig.model.ReplicateTo
  ): zio.aws.appconfig.model.ReplicateTo = value match {
    case software.amazon.awssdk.services.appconfig.model.ReplicateTo.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appconfig.model.ReplicateTo.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.appconfig.model.ReplicateTo.SSM_DOCUMENT =>
      val r = SSM_DOCUMENT
      r
  }
  case object unknownToSdkVersion extends zio.aws.appconfig.model.ReplicateTo {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.ReplicateTo =
      software.amazon.awssdk.services.appconfig.model.ReplicateTo.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.appconfig.model.ReplicateTo {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.ReplicateTo =
      software.amazon.awssdk.services.appconfig.model.ReplicateTo.NONE
  }
  case object SSM_DOCUMENT extends zio.aws.appconfig.model.ReplicateTo {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.ReplicateTo =
      software.amazon.awssdk.services.appconfig.model.ReplicateTo.SSM_DOCUMENT
  }
}
