package zio.aws.appconfig
import zio.aws.appconfig.model.ListHostedConfigurationVersionsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.appconfig.model.{
  StopDeploymentRequest,
  UpdateApplicationRequest,
  GetEnvironmentRequest,
  GetDeploymentStrategyRequest,
  StartDeploymentRequest,
  DeleteApplicationRequest,
  ListEnvironmentsRequest,
  CreateHostedConfigurationVersionRequest,
  CreateConfigurationProfileRequest,
  UpdateEnvironmentRequest,
  CreateApplicationRequest,
  ListTagsForResourceRequest,
  UpdateConfigurationProfileRequest,
  GetConfigurationProfileRequest,
  GetHostedConfigurationVersionRequest,
  ListHostedConfigurationVersionsRequest,
  ValidateConfigurationRequest,
  ListDeploymentsRequest,
  GetApplicationRequest,
  DeleteHostedConfigurationVersionRequest,
  UntagResourceRequest,
  UpdateDeploymentStrategyRequest,
  ListApplicationsRequest,
  CreateEnvironmentRequest,
  GetDeploymentRequest,
  DeleteConfigurationProfileRequest,
  DeleteEnvironmentRequest,
  CreateDeploymentStrategyRequest,
  DeleteDeploymentStrategyRequest,
  ListConfigurationProfilesRequest,
  TagResourceRequest,
  ListDeploymentStrategiesRequest
}
import zio.stream.ZStream
import software.amazon.awssdk.services.appconfig.AppConfigAsyncClient
object AppConfigMock extends Mock[AppConfig] {
  object DeleteEnvironment
      extends Effect[DeleteEnvironmentRequest, AwsError, Unit]
  object StopDeployment
      extends Effect[
        StopDeploymentRequest,
        AwsError,
        zio.aws.appconfig.model.StopDeploymentResponse.ReadOnly
      ]
  object GetApplication
      extends Effect[
        GetApplicationRequest,
        AwsError,
        zio.aws.appconfig.model.GetApplicationResponse.ReadOnly
      ]
  object DeleteApplication
      extends Effect[DeleteApplicationRequest, AwsError, Unit]
  object CreateEnvironment
      extends Effect[
        CreateEnvironmentRequest,
        AwsError,
        zio.aws.appconfig.model.CreateEnvironmentResponse.ReadOnly
      ]
  object GetEnvironment
      extends Effect[
        GetEnvironmentRequest,
        AwsError,
        zio.aws.appconfig.model.GetEnvironmentResponse.ReadOnly
      ]
  object ListDeploymentStrategies
      extends Stream[
        ListDeploymentStrategiesRequest,
        AwsError,
        zio.aws.appconfig.model.DeploymentStrategy.ReadOnly
      ]
  object ListDeploymentStrategiesPaginated
      extends Effect[
        ListDeploymentStrategiesRequest,
        AwsError,
        zio.aws.appconfig.model.ListDeploymentStrategiesResponse.ReadOnly
      ]
  object GetDeployment
      extends Effect[
        GetDeploymentRequest,
        AwsError,
        zio.aws.appconfig.model.GetDeploymentResponse.ReadOnly
      ]
  object CreateApplication
      extends Effect[
        CreateApplicationRequest,
        AwsError,
        zio.aws.appconfig.model.CreateApplicationResponse.ReadOnly
      ]
  object ListDeployments
      extends Stream[
        ListDeploymentsRequest,
        AwsError,
        zio.aws.appconfig.model.DeploymentSummary.ReadOnly
      ]
  object ListDeploymentsPaginated
      extends Effect[
        ListDeploymentsRequest,
        AwsError,
        zio.aws.appconfig.model.ListDeploymentsResponse.ReadOnly
      ]
  object DeleteHostedConfigurationVersion
      extends Effect[DeleteHostedConfigurationVersionRequest, AwsError, Unit]
  object CreateConfigurationProfile
      extends Effect[
        CreateConfigurationProfileRequest,
        AwsError,
        zio.aws.appconfig.model.CreateConfigurationProfileResponse.ReadOnly
      ]
  object ListEnvironments
      extends Stream[
        ListEnvironmentsRequest,
        AwsError,
        zio.aws.appconfig.model.Environment.ReadOnly
      ]
  object ListEnvironmentsPaginated
      extends Effect[
        ListEnvironmentsRequest,
        AwsError,
        zio.aws.appconfig.model.ListEnvironmentsResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object ValidateConfiguration
      extends Effect[ValidateConfigurationRequest, AwsError, Unit]
  object GetDeploymentStrategy
      extends Effect[
        GetDeploymentStrategyRequest,
        AwsError,
        zio.aws.appconfig.model.GetDeploymentStrategyResponse.ReadOnly
      ]
  object GetHostedConfigurationVersion
      extends Effect[
        GetHostedConfigurationVersionRequest,
        AwsError,
        zio.aws.appconfig.model.GetHostedConfigurationVersionResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.appconfig.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object ListApplications
      extends Stream[
        ListApplicationsRequest,
        AwsError,
        zio.aws.appconfig.model.Application.ReadOnly
      ]
  object ListApplicationsPaginated
      extends Effect[
        ListApplicationsRequest,
        AwsError,
        zio.aws.appconfig.model.ListApplicationsResponse.ReadOnly
      ]
  object CreateHostedConfigurationVersion
      extends Effect[
        CreateHostedConfigurationVersionRequest,
        AwsError,
        zio.aws.appconfig.model.CreateHostedConfigurationVersionResponse.ReadOnly
      ]
  object UpdateEnvironment
      extends Effect[
        UpdateEnvironmentRequest,
        AwsError,
        zio.aws.appconfig.model.UpdateEnvironmentResponse.ReadOnly
      ]
  object DeleteConfigurationProfile
      extends Effect[DeleteConfigurationProfileRequest, AwsError, Unit]
  object ListConfigurationProfiles
      extends Stream[
        ListConfigurationProfilesRequest,
        AwsError,
        zio.aws.appconfig.model.ConfigurationProfileSummary.ReadOnly
      ]
  object ListConfigurationProfilesPaginated
      extends Effect[
        ListConfigurationProfilesRequest,
        AwsError,
        zio.aws.appconfig.model.ListConfigurationProfilesResponse.ReadOnly
      ]
  object UpdateApplication
      extends Effect[
        UpdateApplicationRequest,
        AwsError,
        zio.aws.appconfig.model.UpdateApplicationResponse.ReadOnly
      ]
  object UpdateConfigurationProfile
      extends Effect[
        UpdateConfigurationProfileRequest,
        AwsError,
        zio.aws.appconfig.model.UpdateConfigurationProfileResponse.ReadOnly
      ]
  object DeleteDeploymentStrategy
      extends Effect[DeleteDeploymentStrategyRequest, AwsError, Unit]
  object UpdateDeploymentStrategy
      extends Effect[
        UpdateDeploymentStrategyRequest,
        AwsError,
        zio.aws.appconfig.model.UpdateDeploymentStrategyResponse.ReadOnly
      ]
  object StartDeployment
      extends Effect[
        StartDeploymentRequest,
        AwsError,
        zio.aws.appconfig.model.StartDeploymentResponse.ReadOnly
      ]
  object ListHostedConfigurationVersions
      extends Stream[
        ListHostedConfigurationVersionsRequest,
        AwsError,
        zio.aws.appconfig.model.HostedConfigurationVersionSummary.ReadOnly
      ]
  object ListHostedConfigurationVersionsPaginated
      extends Effect[ListHostedConfigurationVersionsRequest, AwsError, ReadOnly]
  object CreateDeploymentStrategy
      extends Effect[
        CreateDeploymentStrategyRequest,
        AwsError,
        zio.aws.appconfig.model.CreateDeploymentStrategyResponse.ReadOnly
      ]
  object GetConfigurationProfile
      extends Effect[
        GetConfigurationProfileRequest,
        AwsError,
        zio.aws.appconfig.model.GetConfigurationProfileResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, AppConfig] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, AppConfig] { rts =>
        zio.ZIO.succeed {
          new AppConfig {
            val api: AppConfigAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): AppConfig = this
            def deleteEnvironment(
                request: DeleteEnvironmentRequest
            ): IO[AwsError, Unit] = proxy(DeleteEnvironment, request)
            def stopDeployment(request: StopDeploymentRequest): IO[
              AwsError,
              zio.aws.appconfig.model.StopDeploymentResponse.ReadOnly
            ] = proxy(StopDeployment, request)
            def getApplication(request: GetApplicationRequest): IO[
              AwsError,
              zio.aws.appconfig.model.GetApplicationResponse.ReadOnly
            ] = proxy(GetApplication, request)
            def deleteApplication(
                request: DeleteApplicationRequest
            ): IO[AwsError, Unit] = proxy(DeleteApplication, request)
            def createEnvironment(request: CreateEnvironmentRequest): IO[
              AwsError,
              zio.aws.appconfig.model.CreateEnvironmentResponse.ReadOnly
            ] = proxy(CreateEnvironment, request)
            def getEnvironment(request: GetEnvironmentRequest): IO[
              AwsError,
              zio.aws.appconfig.model.GetEnvironmentResponse.ReadOnly
            ] = proxy(GetEnvironment, request)
            def listDeploymentStrategies(
                request: ListDeploymentStrategiesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.appconfig.model.DeploymentStrategy.ReadOnly
            ] = rts.unsafeRun(proxy(ListDeploymentStrategies, request))
            def listDeploymentStrategiesPaginated(
                request: ListDeploymentStrategiesRequest
            ): IO[
              AwsError,
              zio.aws.appconfig.model.ListDeploymentStrategiesResponse.ReadOnly
            ] = proxy(ListDeploymentStrategiesPaginated, request)
            def getDeployment(request: GetDeploymentRequest): IO[
              AwsError,
              zio.aws.appconfig.model.GetDeploymentResponse.ReadOnly
            ] = proxy(GetDeployment, request)
            def createApplication(request: CreateApplicationRequest): IO[
              AwsError,
              zio.aws.appconfig.model.CreateApplicationResponse.ReadOnly
            ] = proxy(CreateApplication, request)
            def listDeployments(request: ListDeploymentsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.appconfig.model.DeploymentSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListDeployments, request))
            def listDeploymentsPaginated(request: ListDeploymentsRequest): IO[
              AwsError,
              zio.aws.appconfig.model.ListDeploymentsResponse.ReadOnly
            ] = proxy(ListDeploymentsPaginated, request)
            def deleteHostedConfigurationVersion(
                request: DeleteHostedConfigurationVersionRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteHostedConfigurationVersion, request)
            def createConfigurationProfile(
                request: CreateConfigurationProfileRequest
            ): IO[
              AwsError,
              zio.aws.appconfig.model.CreateConfigurationProfileResponse.ReadOnly
            ] = proxy(CreateConfigurationProfile, request)
            def listEnvironments(request: ListEnvironmentsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.appconfig.model.Environment.ReadOnly
            ] = rts.unsafeRun(proxy(ListEnvironments, request))
            def listEnvironmentsPaginated(request: ListEnvironmentsRequest): IO[
              AwsError,
              zio.aws.appconfig.model.ListEnvironmentsResponse.ReadOnly
            ] = proxy(ListEnvironmentsPaginated, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, Unit] = proxy(UntagResource, request)
            def validateConfiguration(
                request: ValidateConfigurationRequest
            ): IO[AwsError, Unit] = proxy(ValidateConfiguration, request)
            def getDeploymentStrategy(
                request: GetDeploymentStrategyRequest
            ): IO[
              AwsError,
              zio.aws.appconfig.model.GetDeploymentStrategyResponse.ReadOnly
            ] = proxy(GetDeploymentStrategy, request)
            def getHostedConfigurationVersion(
                request: GetHostedConfigurationVersionRequest
            ): IO[
              AwsError,
              zio.aws.appconfig.model.GetHostedConfigurationVersionResponse.ReadOnly
            ] = proxy(GetHostedConfigurationVersion, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.appconfig.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
              proxy(TagResource, request)
            def listApplications(request: ListApplicationsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.appconfig.model.Application.ReadOnly
            ] = rts.unsafeRun(proxy(ListApplications, request))
            def listApplicationsPaginated(request: ListApplicationsRequest): IO[
              AwsError,
              zio.aws.appconfig.model.ListApplicationsResponse.ReadOnly
            ] = proxy(ListApplicationsPaginated, request)
            def createHostedConfigurationVersion(
                request: CreateHostedConfigurationVersionRequest
            ): IO[
              AwsError,
              zio.aws.appconfig.model.CreateHostedConfigurationVersionResponse.ReadOnly
            ] = proxy(CreateHostedConfigurationVersion, request)
            def updateEnvironment(request: UpdateEnvironmentRequest): IO[
              AwsError,
              zio.aws.appconfig.model.UpdateEnvironmentResponse.ReadOnly
            ] = proxy(UpdateEnvironment, request)
            def deleteConfigurationProfile(
                request: DeleteConfigurationProfileRequest
            ): IO[AwsError, Unit] = proxy(DeleteConfigurationProfile, request)
            def listConfigurationProfiles(
                request: ListConfigurationProfilesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.appconfig.model.ConfigurationProfileSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListConfigurationProfiles, request))
            def listConfigurationProfilesPaginated(
                request: ListConfigurationProfilesRequest
            ): IO[
              AwsError,
              zio.aws.appconfig.model.ListConfigurationProfilesResponse.ReadOnly
            ] = proxy(ListConfigurationProfilesPaginated, request)
            def updateApplication(request: UpdateApplicationRequest): IO[
              AwsError,
              zio.aws.appconfig.model.UpdateApplicationResponse.ReadOnly
            ] = proxy(UpdateApplication, request)
            def updateConfigurationProfile(
                request: UpdateConfigurationProfileRequest
            ): IO[
              AwsError,
              zio.aws.appconfig.model.UpdateConfigurationProfileResponse.ReadOnly
            ] = proxy(UpdateConfigurationProfile, request)
            def deleteDeploymentStrategy(
                request: DeleteDeploymentStrategyRequest
            ): IO[AwsError, Unit] = proxy(DeleteDeploymentStrategy, request)
            def updateDeploymentStrategy(
                request: UpdateDeploymentStrategyRequest
            ): IO[
              AwsError,
              zio.aws.appconfig.model.UpdateDeploymentStrategyResponse.ReadOnly
            ] = proxy(UpdateDeploymentStrategy, request)
            def startDeployment(request: StartDeploymentRequest): IO[
              AwsError,
              zio.aws.appconfig.model.StartDeploymentResponse.ReadOnly
            ] = proxy(StartDeployment, request)
            def listHostedConfigurationVersions(
                request: ListHostedConfigurationVersionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.appconfig.model.HostedConfigurationVersionSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListHostedConfigurationVersions, request))
            def listHostedConfigurationVersionsPaginated(
                request: ListHostedConfigurationVersionsRequest
            ): IO[AwsError, ReadOnly] =
              proxy(ListHostedConfigurationVersionsPaginated, request)
            def createDeploymentStrategy(
                request: CreateDeploymentStrategyRequest
            ): IO[
              AwsError,
              zio.aws.appconfig.model.CreateDeploymentStrategyResponse.ReadOnly
            ] = proxy(CreateDeploymentStrategy, request)
            def getConfigurationProfile(
                request: GetConfigurationProfileRequest
            ): IO[
              AwsError,
              zio.aws.appconfig.model.GetConfigurationProfileResponse.ReadOnly
            ] = proxy(GetConfigurationProfile, request)
          }
        }
      }
    }
  }
}
