package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteConfigurationProfileRequest(
    applicationId: Id,
    configurationProfileId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.DeleteConfigurationProfileRequest = {
    import DeleteConfigurationProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.DeleteConfigurationProfileRequest
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .configurationProfileId(
        Id.unwrap(configurationProfileId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.DeleteConfigurationProfileRequest.ReadOnly =
    zio.aws.appconfig.model.DeleteConfigurationProfileRequest
      .wrap(buildAwsValue())
}
object DeleteConfigurationProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.DeleteConfigurationProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.DeleteConfigurationProfileRequest =
      zio.aws.appconfig.model.DeleteConfigurationProfileRequest(
        applicationId,
        configurationProfileId
      )
    def applicationId: Id
    def configurationProfileId: Id
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
    def getConfigurationProfileId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(configurationProfileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.DeleteConfigurationProfileRequest
  ) extends zio.aws.appconfig.model.DeleteConfigurationProfileRequest.ReadOnly {
    override val applicationId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.applicationId())
    override val configurationProfileId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.configurationProfileId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.DeleteConfigurationProfileRequest
  ): zio.aws.appconfig.model.DeleteConfigurationProfileRequest.ReadOnly =
    new Wrapper(impl)
}
