package zio.aws.appconfig.model
import scala.jdk.CollectionConverters.*
sealed trait GrowthType {
  def unwrap: software.amazon.awssdk.services.appconfig.model.GrowthType
}
object GrowthType {
  def wrap(
      value: software.amazon.awssdk.services.appconfig.model.GrowthType
  ): zio.aws.appconfig.model.GrowthType = value match {
    case software.amazon.awssdk.services.appconfig.model.GrowthType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appconfig.model.GrowthType.LINEAR =>
      val r = LINEAR
      r
    case software.amazon.awssdk.services.appconfig.model.GrowthType.EXPONENTIAL =>
      val r = EXPONENTIAL
      r
  }
  case object unknownToSdkVersion extends zio.aws.appconfig.model.GrowthType {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.GrowthType =
      software.amazon.awssdk.services.appconfig.model.GrowthType.UNKNOWN_TO_SDK_VERSION
  }
  case object LINEAR extends zio.aws.appconfig.model.GrowthType {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.GrowthType =
      software.amazon.awssdk.services.appconfig.model.GrowthType.LINEAR
  }
  case object EXPONENTIAL extends zio.aws.appconfig.model.GrowthType {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.GrowthType =
      software.amazon.awssdk.services.appconfig.model.GrowthType.EXPONENTIAL
  }
}
