package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListEnvironmentsResponse(
    items: Optional[Iterable[zio.aws.appconfig.model.Environment]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.ListEnvironmentsResponse = {
    import ListEnvironmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.ListEnvironmentsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.ListEnvironmentsResponse.ReadOnly =
    zio.aws.appconfig.model.ListEnvironmentsResponse.wrap(buildAwsValue())
}
object ListEnvironmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.ListEnvironmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.ListEnvironmentsResponse =
      zio.aws.appconfig.model.ListEnvironmentsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Optional[List[zio.aws.appconfig.model.Environment.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.appconfig.model.Environment.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.ListEnvironmentsResponse
  ) extends zio.aws.appconfig.model.ListEnvironmentsResponse.ReadOnly {
    override val items
        : Optional[List[zio.aws.appconfig.model.Environment.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appconfig.model.Environment.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appconfig.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.ListEnvironmentsResponse
  ): zio.aws.appconfig.model.ListEnvironmentsResponse.ReadOnly = new Wrapper(
    impl
  )
}
