package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{RoleArn, Description, Name, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateConfigurationProfileRequest(
    applicationId: Id,
    configurationProfileId: Id,
    name: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    retrievalRoleArn: Optional[RoleArn] = Optional.Absent,
    validators: Optional[Iterable[zio.aws.appconfig.model.Validator]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.UpdateConfigurationProfileRequest = {
    import UpdateConfigurationProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.UpdateConfigurationProfileRequest
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .configurationProfileId(
        Id.unwrap(configurationProfileId): java.lang.String
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        retrievalRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.retrievalRoleArn)
      .optionallyWith(
        validators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validators)
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.UpdateConfigurationProfileRequest.ReadOnly =
    zio.aws.appconfig.model.UpdateConfigurationProfileRequest
      .wrap(buildAwsValue())
}
object UpdateConfigurationProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.UpdateConfigurationProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.UpdateConfigurationProfileRequest =
      zio.aws.appconfig.model.UpdateConfigurationProfileRequest(
        applicationId,
        configurationProfileId,
        name.map(value => value),
        description.map(value => value),
        retrievalRoleArn.map(value => value),
        validators.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def applicationId: Id
    def configurationProfileId: Id
    def name: Optional[Name]
    def description: Optional[Description]
    def retrievalRoleArn: Optional[RoleArn]
    def validators: Optional[List[zio.aws.appconfig.model.Validator.ReadOnly]]
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
    def getConfigurationProfileId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(configurationProfileId)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRetrievalRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("retrievalRoleArn", retrievalRoleArn)
    def getValidators
        : ZIO[Any, AwsError, List[zio.aws.appconfig.model.Validator.ReadOnly]] =
      AwsError.unwrapOptionField("validators", validators)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.UpdateConfigurationProfileRequest
  ) extends zio.aws.appconfig.model.UpdateConfigurationProfileRequest.ReadOnly {
    override val applicationId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.applicationId())
    override val configurationProfileId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.configurationProfileId())
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.appconfig.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val retrievalRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.retrievalRoleArn())
      .map(value => zio.aws.appconfig.model.primitives.RoleArn(value))
    override val validators
        : Optional[List[zio.aws.appconfig.model.Validator.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validators())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appconfig.model.Validator.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.UpdateConfigurationProfileRequest
  ): zio.aws.appconfig.model.UpdateConfigurationProfileRequest.ReadOnly =
    new Wrapper(impl)
}
