package zio.aws.appconfig.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.appconfig.model.primitives.{
  Percentage,
  MinutesBetween0And24Hours,
  Description,
  Name,
  Id
}
import scala.jdk.CollectionConverters.*
final case class UpdateDeploymentStrategyResponse(
    id: Optional[Id] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    deploymentDurationInMinutes: Optional[MinutesBetween0And24Hours] =
      Optional.Absent,
    growthType: Optional[zio.aws.appconfig.model.GrowthType] = Optional.Absent,
    growthFactor: Optional[Percentage] = Optional.Absent,
    finalBakeTimeInMinutes: Optional[MinutesBetween0And24Hours] =
      Optional.Absent,
    replicateTo: Optional[zio.aws.appconfig.model.ReplicateTo] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.UpdateDeploymentStrategyResponse = {
    import UpdateDeploymentStrategyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.UpdateDeploymentStrategyResponse
      .builder()
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        deploymentDurationInMinutes.map(value =>
          MinutesBetween0And24Hours.unwrap(value): Integer
        )
      )(_.deploymentDurationInMinutes)
      .optionallyWith(growthType.map(value => value.unwrap))(_.growthType)
      .optionallyWith(
        growthFactor.map(value => Percentage.unwrap(value): java.lang.Float)
      )(_.growthFactor)
      .optionallyWith(
        finalBakeTimeInMinutes.map(value =>
          MinutesBetween0And24Hours.unwrap(value): Integer
        )
      )(_.finalBakeTimeInMinutes)
      .optionallyWith(replicateTo.map(value => value.unwrap))(_.replicateTo)
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.UpdateDeploymentStrategyResponse.ReadOnly =
    zio.aws.appconfig.model.UpdateDeploymentStrategyResponse
      .wrap(buildAwsValue())
}
object UpdateDeploymentStrategyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.UpdateDeploymentStrategyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.UpdateDeploymentStrategyResponse =
      zio.aws.appconfig.model.UpdateDeploymentStrategyResponse(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        deploymentDurationInMinutes.map(value => value),
        growthType.map(value => value),
        growthFactor.map(value => value),
        finalBakeTimeInMinutes.map(value => value),
        replicateTo.map(value => value)
      )
    def id: Optional[Id]
    def name: Optional[Name]
    def description: Optional[Description]
    def deploymentDurationInMinutes: Optional[MinutesBetween0And24Hours]
    def growthType: Optional[zio.aws.appconfig.model.GrowthType]
    def growthFactor: Optional[Percentage]
    def finalBakeTimeInMinutes: Optional[MinutesBetween0And24Hours]
    def replicateTo: Optional[zio.aws.appconfig.model.ReplicateTo]
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDeploymentDurationInMinutes
        : ZIO[Any, AwsError, MinutesBetween0And24Hours] =
      AwsError.unwrapOptionField(
        "deploymentDurationInMinutes",
        deploymentDurationInMinutes
      )
    def getGrowthType: ZIO[Any, AwsError, zio.aws.appconfig.model.GrowthType] =
      AwsError.unwrapOptionField("growthType", growthType)
    def getGrowthFactor: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("growthFactor", growthFactor)
    def getFinalBakeTimeInMinutes
        : ZIO[Any, AwsError, MinutesBetween0And24Hours] = AwsError
      .unwrapOptionField("finalBakeTimeInMinutes", finalBakeTimeInMinutes)
    def getReplicateTo
        : ZIO[Any, AwsError, zio.aws.appconfig.model.ReplicateTo] =
      AwsError.unwrapOptionField("replicateTo", replicateTo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.UpdateDeploymentStrategyResponse
  ) extends zio.aws.appconfig.model.UpdateDeploymentStrategyResponse.ReadOnly {
    override val id: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.appconfig.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val deploymentDurationInMinutes
        : Optional[MinutesBetween0And24Hours] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentDurationInMinutes())
      .map(value =>
        zio.aws.appconfig.model.primitives.MinutesBetween0And24Hours(value)
      )
    override val growthType: Optional[zio.aws.appconfig.model.GrowthType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.growthType())
        .map(value => zio.aws.appconfig.model.GrowthType.wrap(value))
    override val growthFactor: Optional[Percentage] = zio.aws.core.internal
      .optionalFromNullable(impl.growthFactor())
      .map(value => zio.aws.appconfig.model.primitives.Percentage(value))
    override val finalBakeTimeInMinutes: Optional[MinutesBetween0And24Hours] =
      zio.aws.core.internal
        .optionalFromNullable(impl.finalBakeTimeInMinutes())
        .map(value =>
          zio.aws.appconfig.model.primitives.MinutesBetween0And24Hours(value)
        )
    override val replicateTo: Optional[zio.aws.appconfig.model.ReplicateTo] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicateTo())
        .map(value => zio.aws.appconfig.model.ReplicateTo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.UpdateDeploymentStrategyResponse
  ): zio.aws.appconfig.model.UpdateDeploymentStrategyResponse.ReadOnly =
    new Wrapper(impl)
}
