package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{Description, Name, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateEnvironmentResponse(
    applicationId: Optional[Id] = Optional.Absent,
    id: Optional[Id] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    state: Optional[zio.aws.appconfig.model.EnvironmentState] = Optional.Absent,
    monitors: Optional[Iterable[zio.aws.appconfig.model.Monitor]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.CreateEnvironmentResponse = {
    import CreateEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.CreateEnvironmentResponse
      .builder()
      .optionallyWith(
        applicationId.map(value => Id.unwrap(value): java.lang.String)
      )(_.applicationId)
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        monitors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.monitors)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.CreateEnvironmentResponse.ReadOnly =
    zio.aws.appconfig.model.CreateEnvironmentResponse.wrap(buildAwsValue())
}
object CreateEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.CreateEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.CreateEnvironmentResponse =
      zio.aws.appconfig.model.CreateEnvironmentResponse(
        applicationId.map(value => value),
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        state.map(value => value),
        monitors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def applicationId: Optional[Id]
    def id: Optional[Id]
    def name: Optional[Name]
    def description: Optional[Description]
    def state: Optional[zio.aws.appconfig.model.EnvironmentState]
    def monitors: Optional[List[zio.aws.appconfig.model.Monitor.ReadOnly]]
    def getApplicationId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getState: ZIO[Any, AwsError, zio.aws.appconfig.model.EnvironmentState] =
      AwsError.unwrapOptionField("state", state)
    def getMonitors
        : ZIO[Any, AwsError, List[zio.aws.appconfig.model.Monitor.ReadOnly]] =
      AwsError.unwrapOptionField("monitors", monitors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.CreateEnvironmentResponse
  ) extends zio.aws.appconfig.model.CreateEnvironmentResponse.ReadOnly {
    override val applicationId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val id: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.appconfig.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val state: Optional[zio.aws.appconfig.model.EnvironmentState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.appconfig.model.EnvironmentState.wrap(value))
    override val monitors
        : Optional[List[zio.aws.appconfig.model.Monitor.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appconfig.model.Monitor.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.CreateEnvironmentResponse
  ): zio.aws.appconfig.model.CreateEnvironmentResponse.ReadOnly = new Wrapper(
    impl
  )
}
