package zio.aws.appconfig.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.appconfig.model.primitives.{
  StringWithLengthBetween1And255,
  Description,
  Blob,
  Id
}
import scala.jdk.CollectionConverters.*
final case class CreateHostedConfigurationVersionRequest(
    applicationId: Id,
    configurationProfileId: Id,
    description: Optional[Description] = Optional.Absent,
    content: Blob,
    contentType: StringWithLengthBetween1And255,
    latestVersionNumber: Optional[zio.aws.appconfig.model.primitives.Integer] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.CreateHostedConfigurationVersionRequest = {
    import CreateHostedConfigurationVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.CreateHostedConfigurationVersionRequest
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .configurationProfileId(
        Id.unwrap(configurationProfileId): java.lang.String
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .content(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(content.toArray[Byte])
      )
      .contentType(
        StringWithLengthBetween1And255.unwrap(contentType): java.lang.String
      )
      .optionallyWith(latestVersionNumber.map(value => value: Integer))(
        _.latestVersionNumber
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.CreateHostedConfigurationVersionRequest.ReadOnly =
    zio.aws.appconfig.model.CreateHostedConfigurationVersionRequest
      .wrap(buildAwsValue())
}
object CreateHostedConfigurationVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.CreateHostedConfigurationVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appconfig.model.CreateHostedConfigurationVersionRequest =
      zio.aws.appconfig.model.CreateHostedConfigurationVersionRequest(
        applicationId,
        configurationProfileId,
        description.map(value => value),
        content,
        contentType,
        latestVersionNumber.map(value => value)
      )
    def applicationId: Id
    def configurationProfileId: Id
    def description: Optional[Description]
    def content: Blob
    def contentType: StringWithLengthBetween1And255
    def latestVersionNumber
        : Optional[zio.aws.appconfig.model.primitives.Integer]
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
    def getConfigurationProfileId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(configurationProfileId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getContent: ZIO[Any, Nothing, Blob] = ZIO.succeed(content)
    def getContentType: ZIO[Any, Nothing, StringWithLengthBetween1And255] =
      ZIO.succeed(contentType)
    def getLatestVersionNumber
        : ZIO[Any, AwsError, zio.aws.appconfig.model.primitives.Integer] =
      AwsError.unwrapOptionField("latestVersionNumber", latestVersionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.CreateHostedConfigurationVersionRequest
  ) extends zio.aws.appconfig.model.CreateHostedConfigurationVersionRequest.ReadOnly {
    override val applicationId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.applicationId())
    override val configurationProfileId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.configurationProfileId())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val content: Blob = zio.aws.appconfig.model.primitives
      .Blob(zio.Chunk.fromArray(impl.content().asByteArrayUnsafe()))
    override val contentType: StringWithLengthBetween1And255 =
      zio.aws.appconfig.model.primitives
        .StringWithLengthBetween1And255(impl.contentType())
    override val latestVersionNumber
        : Optional[zio.aws.appconfig.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestVersionNumber())
        .map(value => value: zio.aws.appconfig.model.primitives.Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.CreateHostedConfigurationVersionRequest
  ): zio.aws.appconfig.model.CreateHostedConfigurationVersionRequest.ReadOnly =
    new Wrapper(impl)
}
