package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteEnvironmentRequest(
    applicationId: Id,
    environmentId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.DeleteEnvironmentRequest = {
    import DeleteEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.DeleteEnvironmentRequest
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .environmentId(Id.unwrap(environmentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.DeleteEnvironmentRequest.ReadOnly =
    zio.aws.appconfig.model.DeleteEnvironmentRequest.wrap(buildAwsValue())
}
object DeleteEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.DeleteEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.DeleteEnvironmentRequest =
      zio.aws.appconfig.model
        .DeleteEnvironmentRequest(applicationId, environmentId)
    def applicationId: Id
    def environmentId: Id
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
    def getEnvironmentId: ZIO[Any, Nothing, Id] = ZIO.succeed(environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.DeleteEnvironmentRequest
  ) extends zio.aws.appconfig.model.DeleteEnvironmentRequest.ReadOnly {
    override val applicationId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.applicationId())
    override val environmentId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.environmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.DeleteEnvironmentRequest
  ): zio.aws.appconfig.model.DeleteEnvironmentRequest.ReadOnly = new Wrapper(
    impl
  )
}
