package zio.aws.appconfig.model
import scala.jdk.CollectionConverters.*
sealed trait DeploymentState {
  def unwrap: software.amazon.awssdk.services.appconfig.model.DeploymentState
}
object DeploymentState {
  def wrap(
      value: software.amazon.awssdk.services.appconfig.model.DeploymentState
  ): zio.aws.appconfig.model.DeploymentState = value match {
    case software.amazon.awssdk.services.appconfig.model.DeploymentState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appconfig.model.DeploymentState.BAKING =>
      val r = BAKING
      r
    case software.amazon.awssdk.services.appconfig.model.DeploymentState.VALIDATING =>
      val r = VALIDATING
      r
    case software.amazon.awssdk.services.appconfig.model.DeploymentState.DEPLOYING =>
      val r = DEPLOYING
      r
    case software.amazon.awssdk.services.appconfig.model.DeploymentState.COMPLETE =>
      val r = COMPLETE
      r
    case software.amazon.awssdk.services.appconfig.model.DeploymentState.ROLLING_BACK =>
      val r = ROLLING_BACK
      r
    case software.amazon.awssdk.services.appconfig.model.DeploymentState.ROLLED_BACK =>
      val r = ROLLED_BACK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appconfig.model.DeploymentState {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.DeploymentState =
      software.amazon.awssdk.services.appconfig.model.DeploymentState.UNKNOWN_TO_SDK_VERSION
  }
  case object BAKING extends zio.aws.appconfig.model.DeploymentState {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.DeploymentState =
      software.amazon.awssdk.services.appconfig.model.DeploymentState.BAKING
  }
  case object VALIDATING extends zio.aws.appconfig.model.DeploymentState {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.DeploymentState =
      software.amazon.awssdk.services.appconfig.model.DeploymentState.VALIDATING
  }
  case object DEPLOYING extends zio.aws.appconfig.model.DeploymentState {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.DeploymentState =
      software.amazon.awssdk.services.appconfig.model.DeploymentState.DEPLOYING
  }
  case object COMPLETE extends zio.aws.appconfig.model.DeploymentState {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.DeploymentState =
      software.amazon.awssdk.services.appconfig.model.DeploymentState.COMPLETE
  }
  case object ROLLING_BACK extends zio.aws.appconfig.model.DeploymentState {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.DeploymentState =
      software.amazon.awssdk.services.appconfig.model.DeploymentState.ROLLING_BACK
  }
  case object ROLLED_BACK extends zio.aws.appconfig.model.DeploymentState {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.DeploymentState =
      software.amazon.awssdk.services.appconfig.model.DeploymentState.ROLLED_BACK
  }
}
