package zio.aws.appconfig.model
import scala.jdk.CollectionConverters.*
sealed trait EnvironmentState {
  def unwrap: software.amazon.awssdk.services.appconfig.model.EnvironmentState
}
object EnvironmentState {
  def wrap(
      value: software.amazon.awssdk.services.appconfig.model.EnvironmentState
  ): zio.aws.appconfig.model.EnvironmentState = value match {
    case software.amazon.awssdk.services.appconfig.model.EnvironmentState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appconfig.model.EnvironmentState.READY_FOR_DEPLOYMENT =>
      val r = READY_FOR_DEPLOYMENT
      r
    case software.amazon.awssdk.services.appconfig.model.EnvironmentState.DEPLOYING =>
      val r = DEPLOYING
      r
    case software.amazon.awssdk.services.appconfig.model.EnvironmentState.ROLLING_BACK =>
      val r = ROLLING_BACK
      r
    case software.amazon.awssdk.services.appconfig.model.EnvironmentState.ROLLED_BACK =>
      val r = ROLLED_BACK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appconfig.model.EnvironmentState {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.EnvironmentState =
      software.amazon.awssdk.services.appconfig.model.EnvironmentState.UNKNOWN_TO_SDK_VERSION
  }
  case object READY_FOR_DEPLOYMENT
      extends zio.aws.appconfig.model.EnvironmentState {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.EnvironmentState =
      software.amazon.awssdk.services.appconfig.model.EnvironmentState.READY_FOR_DEPLOYMENT
  }
  case object DEPLOYING extends zio.aws.appconfig.model.EnvironmentState {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.EnvironmentState =
      software.amazon.awssdk.services.appconfig.model.EnvironmentState.DEPLOYING
  }
  case object ROLLING_BACK extends zio.aws.appconfig.model.EnvironmentState {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.EnvironmentState =
      software.amazon.awssdk.services.appconfig.model.EnvironmentState.ROLLING_BACK
  }
  case object ROLLED_BACK extends zio.aws.appconfig.model.EnvironmentState {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.EnvironmentState =
      software.amazon.awssdk.services.appconfig.model.EnvironmentState.ROLLED_BACK
  }
}
