package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetApplicationRequest(applicationId: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.GetApplicationRequest = {
    import GetApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.GetApplicationRequest
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.GetApplicationRequest.ReadOnly =
    zio.aws.appconfig.model.GetApplicationRequest.wrap(buildAwsValue())
}
object GetApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.GetApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.GetApplicationRequest =
      zio.aws.appconfig.model.GetApplicationRequest(applicationId)
    def applicationId: Id
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.GetApplicationRequest
  ) extends zio.aws.appconfig.model.GetApplicationRequest.ReadOnly {
    override val applicationId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.applicationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.GetApplicationRequest
  ): zio.aws.appconfig.model.GetApplicationRequest.ReadOnly = new Wrapper(impl)
}
