package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.Id
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetDeploymentRequest(
    applicationId: Id,
    environmentId: Id,
    deploymentNumber: zio.aws.appconfig.model.primitives.Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.GetDeploymentRequest = {
    import GetDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.GetDeploymentRequest
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .environmentId(Id.unwrap(environmentId): java.lang.String)
      .deploymentNumber(deploymentNumber: Integer)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.GetDeploymentRequest.ReadOnly =
    zio.aws.appconfig.model.GetDeploymentRequest.wrap(buildAwsValue())
}
object GetDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.GetDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.GetDeploymentRequest =
      zio.aws.appconfig.model
        .GetDeploymentRequest(applicationId, environmentId, deploymentNumber)
    def applicationId: Id
    def environmentId: Id
    def deploymentNumber: zio.aws.appconfig.model.primitives.Integer
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
    def getEnvironmentId: ZIO[Any, Nothing, Id] = ZIO.succeed(environmentId)
    def getDeploymentNumber
        : ZIO[Any, Nothing, zio.aws.appconfig.model.primitives.Integer] =
      ZIO.succeed(deploymentNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.GetDeploymentRequest
  ) extends zio.aws.appconfig.model.GetDeploymentRequest.ReadOnly {
    override val applicationId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.applicationId())
    override val environmentId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.environmentId())
    override val deploymentNumber: zio.aws.appconfig.model.primitives.Integer =
      impl.deploymentNumber(): zio.aws.appconfig.model.primitives.Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.GetDeploymentRequest
  ): zio.aws.appconfig.model.GetDeploymentRequest.ReadOnly = new Wrapper(impl)
}
