package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.DeploymentStrategyId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetDeploymentStrategyRequest(
    deploymentStrategyId: DeploymentStrategyId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.GetDeploymentStrategyRequest = {
    import GetDeploymentStrategyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.GetDeploymentStrategyRequest
      .builder()
      .deploymentStrategyId(
        DeploymentStrategyId.unwrap(deploymentStrategyId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.GetDeploymentStrategyRequest.ReadOnly =
    zio.aws.appconfig.model.GetDeploymentStrategyRequest.wrap(buildAwsValue())
}
object GetDeploymentStrategyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.GetDeploymentStrategyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.GetDeploymentStrategyRequest =
      zio.aws.appconfig.model.GetDeploymentStrategyRequest(deploymentStrategyId)
    def deploymentStrategyId: DeploymentStrategyId
    def getDeploymentStrategyId: ZIO[Any, Nothing, DeploymentStrategyId] =
      ZIO.succeed(deploymentStrategyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.GetDeploymentStrategyRequest
  ) extends zio.aws.appconfig.model.GetDeploymentStrategyRequest.ReadOnly {
    override val deploymentStrategyId: DeploymentStrategyId =
      zio.aws.appconfig.model.primitives
        .DeploymentStrategyId(impl.deploymentStrategyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.GetDeploymentStrategyRequest
  ): zio.aws.appconfig.model.GetDeploymentStrategyRequest.ReadOnly =
    new Wrapper(impl)
}
