package zio.aws.appconfig.model
import scala.jdk.CollectionConverters.*
sealed trait ActionPoint {
  def unwrap: software.amazon.awssdk.services.appconfig.model.ActionPoint
}
object ActionPoint {
  def wrap(
      value: software.amazon.awssdk.services.appconfig.model.ActionPoint
  ): zio.aws.appconfig.model.ActionPoint = value match {
    case software.amazon.awssdk.services.appconfig.model.ActionPoint.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appconfig.model.ActionPoint.PRE_CREATE_HOSTED_CONFIGURATION_VERSION =>
      val r = PRE_CREATE_HOSTED_CONFIGURATION_VERSION
      r
    case software.amazon.awssdk.services.appconfig.model.ActionPoint.PRE_START_DEPLOYMENT =>
      val r = PRE_START_DEPLOYMENT
      r
    case software.amazon.awssdk.services.appconfig.model.ActionPoint.ON_DEPLOYMENT_START =>
      val r = ON_DEPLOYMENT_START
      r
    case software.amazon.awssdk.services.appconfig.model.ActionPoint.ON_DEPLOYMENT_STEP =>
      val r = ON_DEPLOYMENT_STEP
      r
    case software.amazon.awssdk.services.appconfig.model.ActionPoint.ON_DEPLOYMENT_BAKING =>
      val r = ON_DEPLOYMENT_BAKING
      r
    case software.amazon.awssdk.services.appconfig.model.ActionPoint.ON_DEPLOYMENT_COMPLETE =>
      val r = ON_DEPLOYMENT_COMPLETE
      r
    case software.amazon.awssdk.services.appconfig.model.ActionPoint.ON_DEPLOYMENT_ROLLED_BACK =>
      val r = ON_DEPLOYMENT_ROLLED_BACK
      r
  }
  case object unknownToSdkVersion extends zio.aws.appconfig.model.ActionPoint {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.ActionPoint =
      software.amazon.awssdk.services.appconfig.model.ActionPoint.UNKNOWN_TO_SDK_VERSION
  }
  case object PRE_CREATE_HOSTED_CONFIGURATION_VERSION
      extends zio.aws.appconfig.model.ActionPoint {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.ActionPoint =
      software.amazon.awssdk.services.appconfig.model.ActionPoint.PRE_CREATE_HOSTED_CONFIGURATION_VERSION
  }
  case object PRE_START_DEPLOYMENT extends zio.aws.appconfig.model.ActionPoint {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.ActionPoint =
      software.amazon.awssdk.services.appconfig.model.ActionPoint.PRE_START_DEPLOYMENT
  }
  case object ON_DEPLOYMENT_START extends zio.aws.appconfig.model.ActionPoint {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.ActionPoint =
      software.amazon.awssdk.services.appconfig.model.ActionPoint.ON_DEPLOYMENT_START
  }
  case object ON_DEPLOYMENT_STEP extends zio.aws.appconfig.model.ActionPoint {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.ActionPoint =
      software.amazon.awssdk.services.appconfig.model.ActionPoint.ON_DEPLOYMENT_STEP
  }
  case object ON_DEPLOYMENT_BAKING extends zio.aws.appconfig.model.ActionPoint {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.ActionPoint =
      software.amazon.awssdk.services.appconfig.model.ActionPoint.ON_DEPLOYMENT_BAKING
  }
  case object ON_DEPLOYMENT_COMPLETE
      extends zio.aws.appconfig.model.ActionPoint {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.ActionPoint =
      software.amazon.awssdk.services.appconfig.model.ActionPoint.ON_DEPLOYMENT_COMPLETE
  }
  case object ON_DEPLOYMENT_ROLLED_BACK
      extends zio.aws.appconfig.model.ActionPoint {
    override def unwrap
        : software.amazon.awssdk.services.appconfig.model.ActionPoint =
      software.amazon.awssdk.services.appconfig.model.ActionPoint.ON_DEPLOYMENT_ROLLED_BACK
  }
}
