package zio.aws.appconfig.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.appconfig.model.primitives.{
  TagValue,
  MinutesBetween0And24Hours,
  Description,
  GrowthFactor,
  Name,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class CreateDeploymentStrategyRequest(
    name: Name,
    description: Optional[Description] = Optional.Absent,
    deploymentDurationInMinutes: MinutesBetween0And24Hours,
    finalBakeTimeInMinutes: Optional[MinutesBetween0And24Hours] =
      Optional.Absent,
    growthFactor: GrowthFactor,
    growthType: Optional[zio.aws.appconfig.model.GrowthType] = Optional.Absent,
    replicateTo: Optional[zio.aws.appconfig.model.ReplicateTo] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.CreateDeploymentStrategyRequest = {
    import CreateDeploymentStrategyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.CreateDeploymentStrategyRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .deploymentDurationInMinutes(
        MinutesBetween0And24Hours.unwrap(deploymentDurationInMinutes): Integer
      )
      .optionallyWith(
        finalBakeTimeInMinutes.map(value =>
          MinutesBetween0And24Hours.unwrap(value): Integer
        )
      )(_.finalBakeTimeInMinutes)
      .growthFactor(GrowthFactor.unwrap(growthFactor): java.lang.Float)
      .optionallyWith(growthType.map(value => value.unwrap))(_.growthType)
      .optionallyWith(replicateTo.map(value => value.unwrap))(_.replicateTo)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.CreateDeploymentStrategyRequest.ReadOnly =
    zio.aws.appconfig.model.CreateDeploymentStrategyRequest
      .wrap(buildAwsValue())
}
object CreateDeploymentStrategyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.CreateDeploymentStrategyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.CreateDeploymentStrategyRequest =
      zio.aws.appconfig.model.CreateDeploymentStrategyRequest(
        name,
        description.map(value => value),
        deploymentDurationInMinutes,
        finalBakeTimeInMinutes.map(value => value),
        growthFactor,
        growthType.map(value => value),
        replicateTo.map(value => value),
        tags.map(value => value)
      )
    def name: Name
    def description: Optional[Description]
    def deploymentDurationInMinutes: MinutesBetween0And24Hours
    def finalBakeTimeInMinutes: Optional[MinutesBetween0And24Hours]
    def growthFactor: GrowthFactor
    def growthType: Optional[zio.aws.appconfig.model.GrowthType]
    def replicateTo: Optional[zio.aws.appconfig.model.ReplicateTo]
    def tags: Optional[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDeploymentDurationInMinutes
        : ZIO[Any, Nothing, MinutesBetween0And24Hours] =
      ZIO.succeed(deploymentDurationInMinutes)
    def getFinalBakeTimeInMinutes
        : ZIO[Any, AwsError, MinutesBetween0And24Hours] = AwsError
      .unwrapOptionField("finalBakeTimeInMinutes", finalBakeTimeInMinutes)
    def getGrowthFactor: ZIO[Any, Nothing, GrowthFactor] =
      ZIO.succeed(growthFactor)
    def getGrowthType: ZIO[Any, AwsError, zio.aws.appconfig.model.GrowthType] =
      AwsError.unwrapOptionField("growthType", growthType)
    def getReplicateTo
        : ZIO[Any, AwsError, zio.aws.appconfig.model.ReplicateTo] =
      AwsError.unwrapOptionField("replicateTo", replicateTo)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.CreateDeploymentStrategyRequest
  ) extends zio.aws.appconfig.model.CreateDeploymentStrategyRequest.ReadOnly {
    override val name: Name =
      zio.aws.appconfig.model.primitives.Name(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val deploymentDurationInMinutes: MinutesBetween0And24Hours =
      zio.aws.appconfig.model.primitives
        .MinutesBetween0And24Hours(impl.deploymentDurationInMinutes())
    override val finalBakeTimeInMinutes: Optional[MinutesBetween0And24Hours] =
      zio.aws.core.internal
        .optionalFromNullable(impl.finalBakeTimeInMinutes())
        .map(value =>
          zio.aws.appconfig.model.primitives.MinutesBetween0And24Hours(value)
        )
    override val growthFactor: GrowthFactor =
      zio.aws.appconfig.model.primitives.GrowthFactor(impl.growthFactor())
    override val growthType: Optional[zio.aws.appconfig.model.GrowthType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.growthType())
        .map(value => zio.aws.appconfig.model.GrowthType.wrap(value))
    override val replicateTo: Optional[zio.aws.appconfig.model.ReplicateTo] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicateTo())
        .map(value => zio.aws.appconfig.model.ReplicateTo.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appconfig.model.primitives
              .TagKey(key) -> zio.aws.appconfig.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.CreateDeploymentStrategyRequest
  ): zio.aws.appconfig.model.CreateDeploymentStrategyRequest.ReadOnly =
    new Wrapper(impl)
}
