package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{
  TagValue,
  Description,
  Name,
  Id,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateEnvironmentRequest(
    applicationId: Id,
    name: Name,
    description: Optional[Description] = Optional.Absent,
    monitors: Optional[Iterable[zio.aws.appconfig.model.Monitor]] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.CreateEnvironmentRequest = {
    import CreateEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.CreateEnvironmentRequest
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        monitors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.monitors)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.CreateEnvironmentRequest.ReadOnly =
    zio.aws.appconfig.model.CreateEnvironmentRequest.wrap(buildAwsValue())
}
object CreateEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.CreateEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.CreateEnvironmentRequest =
      zio.aws.appconfig.model.CreateEnvironmentRequest(
        applicationId,
        name,
        description.map(value => value),
        monitors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value)
      )
    def applicationId: Id
    def name: Name
    def description: Optional[Description]
    def monitors: Optional[List[zio.aws.appconfig.model.Monitor.ReadOnly]]
    def tags: Optional[Map[TagKey, TagValue]]
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getMonitors
        : ZIO[Any, AwsError, List[zio.aws.appconfig.model.Monitor.ReadOnly]] =
      AwsError.unwrapOptionField("monitors", monitors)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.CreateEnvironmentRequest
  ) extends zio.aws.appconfig.model.CreateEnvironmentRequest.ReadOnly {
    override val applicationId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.applicationId())
    override val name: Name =
      zio.aws.appconfig.model.primitives.Name(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val monitors
        : Optional[List[zio.aws.appconfig.model.Monitor.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appconfig.model.Monitor.wrap(item)
          }.toList
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appconfig.model.primitives
              .TagKey(key) -> zio.aws.appconfig.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.CreateEnvironmentRequest
  ): zio.aws.appconfig.model.CreateEnvironmentRequest.ReadOnly = new Wrapper(
    impl
  )
}
