package zio.aws.appconfig.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.appconfig.model.primitives.{TagValue, Description, Name, TagKey}
import scala.jdk.CollectionConverters.*
final case class CreateExtensionRequest(
    name: Name,
    description: Optional[Description] = Optional.Absent,
    actions: Map[zio.aws.appconfig.model.ActionPoint, Iterable[
      zio.aws.appconfig.model.Action
    ]],
    parameters: Optional[Map[Name, zio.aws.appconfig.model.Parameter]] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    latestVersionNumber: Optional[zio.aws.appconfig.model.primitives.Integer] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.CreateExtensionRequest = {
    import CreateExtensionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.CreateExtensionRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .actionsWithStrings(
        actions
          .map({ case (key, value) =>
            key.unwrap.toString -> value.map { item =>
              item.buildAwsValue()
            }.asJavaCollection
          })
          .asJava
      )
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(latestVersionNumber.map(value => value: Integer))(
        _.latestVersionNumber
      )
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.CreateExtensionRequest.ReadOnly =
    zio.aws.appconfig.model.CreateExtensionRequest.wrap(buildAwsValue())
}
object CreateExtensionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.CreateExtensionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.CreateExtensionRequest =
      zio.aws.appconfig.model.CreateExtensionRequest(
        name,
        description.map(value => value),
        actions.map({ case (key, value) =>
          key -> value.map { item =>
            item.asEditable
          }
        }),
        parameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        tags.map(value => value),
        latestVersionNumber.map(value => value)
      )
    def name: Name
    def description: Optional[Description]
    def actions: Map[zio.aws.appconfig.model.ActionPoint, List[
      zio.aws.appconfig.model.Action.ReadOnly
    ]]
    def parameters
        : Optional[Map[Name, zio.aws.appconfig.model.Parameter.ReadOnly]]
    def tags: Optional[Map[TagKey, TagValue]]
    def latestVersionNumber
        : Optional[zio.aws.appconfig.model.primitives.Integer]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getActions
        : ZIO[Any, Nothing, Map[zio.aws.appconfig.model.ActionPoint, List[
          zio.aws.appconfig.model.Action.ReadOnly
        ]]] = ZIO.succeed(actions)
    def getParameters: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.appconfig.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getLatestVersionNumber
        : ZIO[Any, AwsError, zio.aws.appconfig.model.primitives.Integer] =
      AwsError.unwrapOptionField("latestVersionNumber", latestVersionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.CreateExtensionRequest
  ) extends zio.aws.appconfig.model.CreateExtensionRequest.ReadOnly {
    override val name: Name =
      zio.aws.appconfig.model.primitives.Name(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val actions: Map[zio.aws.appconfig.model.ActionPoint, List[
      zio.aws.appconfig.model.Action.ReadOnly
    ]] = impl
      .actions()
      .asScala
      .map({ case (key, value) =>
        zio.aws.appconfig.model.ActionPoint.wrap(key) -> value.asScala.map {
          item =>
            zio.aws.appconfig.model.Action.wrap(item)
        }.toList
      })
      .toMap
    override val parameters
        : Optional[Map[Name, zio.aws.appconfig.model.Parameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.appconfig.model.primitives
                .Name(key) -> zio.aws.appconfig.model.Parameter.wrap(value)
            })
            .toMap
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appconfig.model.primitives
              .TagKey(key) -> zio.aws.appconfig.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val latestVersionNumber
        : Optional[zio.aws.appconfig.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestVersionNumber())
        .map(value => value: zio.aws.appconfig.model.primitives.Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.CreateExtensionRequest
  ): zio.aws.appconfig.model.CreateExtensionRequest.ReadOnly = new Wrapper(impl)
}
