package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteApplicationRequest(applicationId: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.DeleteApplicationRequest = {
    import DeleteApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.DeleteApplicationRequest
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.DeleteApplicationRequest.ReadOnly =
    zio.aws.appconfig.model.DeleteApplicationRequest.wrap(buildAwsValue())
}
object DeleteApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.DeleteApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.DeleteApplicationRequest =
      zio.aws.appconfig.model.DeleteApplicationRequest(applicationId)
    def applicationId: Id
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.DeleteApplicationRequest
  ) extends zio.aws.appconfig.model.DeleteApplicationRequest.ReadOnly {
    override val applicationId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.applicationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.DeleteApplicationRequest
  ): zio.aws.appconfig.model.DeleteApplicationRequest.ReadOnly = new Wrapper(
    impl
  )
}
