package zio.aws.appconfig.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.appconfig.model.primitives.Identifier
import scala.jdk.CollectionConverters.*
final case class DeleteExtensionRequest(
    extensionIdentifier: Identifier,
    versionNumber: Optional[zio.aws.appconfig.model.primitives.Integer] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.DeleteExtensionRequest = {
    import DeleteExtensionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.DeleteExtensionRequest
      .builder()
      .extensionIdentifier(
        Identifier.unwrap(extensionIdentifier): java.lang.String
      )
      .optionallyWith(versionNumber.map(value => value: Integer))(
        _.versionNumber
      )
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.DeleteExtensionRequest.ReadOnly =
    zio.aws.appconfig.model.DeleteExtensionRequest.wrap(buildAwsValue())
}
object DeleteExtensionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.DeleteExtensionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.DeleteExtensionRequest =
      zio.aws.appconfig.model.DeleteExtensionRequest(
        extensionIdentifier,
        versionNumber.map(value => value)
      )
    def extensionIdentifier: Identifier
    def versionNumber: Optional[zio.aws.appconfig.model.primitives.Integer]
    def getExtensionIdentifier: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(extensionIdentifier)
    def getVersionNumber
        : ZIO[Any, AwsError, zio.aws.appconfig.model.primitives.Integer] =
      AwsError.unwrapOptionField("versionNumber", versionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.DeleteExtensionRequest
  ) extends zio.aws.appconfig.model.DeleteExtensionRequest.ReadOnly {
    override val extensionIdentifier: Identifier =
      zio.aws.appconfig.model.primitives.Identifier(impl.extensionIdentifier())
    override val versionNumber
        : Optional[zio.aws.appconfig.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionNumber())
        .map(value => value: zio.aws.appconfig.model.primitives.Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.DeleteExtensionRequest
  ): zio.aws.appconfig.model.DeleteExtensionRequest.ReadOnly = new Wrapper(impl)
}
