package zio.aws.appconfig.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.appconfig.model.primitives.{Iso8601DateTime, Description}
import scala.jdk.CollectionConverters.*
final case class DeploymentEvent(
    eventType: Optional[zio.aws.appconfig.model.DeploymentEventType] =
      Optional.Absent,
    triggeredBy: Optional[zio.aws.appconfig.model.TriggeredBy] =
      Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    actionInvocations: Optional[
      Iterable[zio.aws.appconfig.model.ActionInvocation]
    ] = Optional.Absent,
    occurredAt: Optional[Iso8601DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.DeploymentEvent = {
    import DeploymentEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.DeploymentEvent
      .builder()
      .optionallyWith(eventType.map(value => value.unwrap))(_.eventType)
      .optionallyWith(triggeredBy.map(value => value.unwrap))(_.triggeredBy)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        actionInvocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actionInvocations)
      .optionallyWith(
        occurredAt.map(value => Iso8601DateTime.unwrap(value): Instant)
      )(_.occurredAt)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.DeploymentEvent.ReadOnly =
    zio.aws.appconfig.model.DeploymentEvent.wrap(buildAwsValue())
}
object DeploymentEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.DeploymentEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.DeploymentEvent =
      zio.aws.appconfig.model.DeploymentEvent(
        eventType.map(value => value),
        triggeredBy.map(value => value),
        description.map(value => value),
        actionInvocations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        occurredAt.map(value => value)
      )
    def eventType: Optional[zio.aws.appconfig.model.DeploymentEventType]
    def triggeredBy: Optional[zio.aws.appconfig.model.TriggeredBy]
    def description: Optional[Description]
    def actionInvocations
        : Optional[List[zio.aws.appconfig.model.ActionInvocation.ReadOnly]]
    def occurredAt: Optional[Iso8601DateTime]
    def getEventType
        : ZIO[Any, AwsError, zio.aws.appconfig.model.DeploymentEventType] =
      AwsError.unwrapOptionField("eventType", eventType)
    def getTriggeredBy
        : ZIO[Any, AwsError, zio.aws.appconfig.model.TriggeredBy] =
      AwsError.unwrapOptionField("triggeredBy", triggeredBy)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getActionInvocations: ZIO[Any, AwsError, List[
      zio.aws.appconfig.model.ActionInvocation.ReadOnly
    ]] = AwsError.unwrapOptionField("actionInvocations", actionInvocations)
    def getOccurredAt: ZIO[Any, AwsError, Iso8601DateTime] =
      AwsError.unwrapOptionField("occurredAt", occurredAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.DeploymentEvent
  ) extends zio.aws.appconfig.model.DeploymentEvent.ReadOnly {
    override val eventType
        : Optional[zio.aws.appconfig.model.DeploymentEventType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventType())
        .map(value => zio.aws.appconfig.model.DeploymentEventType.wrap(value))
    override val triggeredBy: Optional[zio.aws.appconfig.model.TriggeredBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.triggeredBy())
        .map(value => zio.aws.appconfig.model.TriggeredBy.wrap(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val actionInvocations
        : Optional[List[zio.aws.appconfig.model.ActionInvocation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionInvocations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appconfig.model.ActionInvocation.wrap(item)
          }.toList
        )
    override val occurredAt: Optional[Iso8601DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.occurredAt())
      .map(value => zio.aws.appconfig.model.primitives.Iso8601DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.DeploymentEvent
  ): zio.aws.appconfig.model.DeploymentEvent.ReadOnly = new Wrapper(impl)
}
