package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetExtensionAssociationRequest(extensionAssociationId: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.GetExtensionAssociationRequest = {
    import GetExtensionAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.GetExtensionAssociationRequest
      .builder()
      .extensionAssociationId(
        Id.unwrap(extensionAssociationId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.GetExtensionAssociationRequest.ReadOnly =
    zio.aws.appconfig.model.GetExtensionAssociationRequest.wrap(buildAwsValue())
}
object GetExtensionAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.GetExtensionAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.GetExtensionAssociationRequest =
      zio.aws.appconfig.model
        .GetExtensionAssociationRequest(extensionAssociationId)
    def extensionAssociationId: Id
    def getExtensionAssociationId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(extensionAssociationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.GetExtensionAssociationRequest
  ) extends zio.aws.appconfig.model.GetExtensionAssociationRequest.ReadOnly {
    override val extensionAssociationId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.extensionAssociationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.GetExtensionAssociationRequest
  ): zio.aws.appconfig.model.GetExtensionAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
