package zio.aws.appconfig.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.appconfig.model.primitives.{
  Identifier,
  Arn,
  Name,
  StringWithLengthBetween1And2048
}
import scala.jdk.CollectionConverters.*
final case class GetExtensionAssociationResponse(
    id: Optional[Identifier] = Optional.Absent,
    extensionArn: Optional[Arn] = Optional.Absent,
    resourceArn: Optional[Arn] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    parameters: Optional[Map[Name, StringWithLengthBetween1And2048]] =
      Optional.Absent,
    extensionVersionNumber: Optional[
      zio.aws.appconfig.model.primitives.Integer
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.GetExtensionAssociationResponse = {
    import GetExtensionAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.GetExtensionAssociationResponse
      .builder()
      .optionallyWith(
        id.map(value => Identifier.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        extensionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.extensionArn)
      .optionallyWith(
        resourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(
                key
              ): java.lang.String) -> (StringWithLengthBetween1And2048
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(extensionVersionNumber.map(value => value: Integer))(
        _.extensionVersionNumber
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.GetExtensionAssociationResponse.ReadOnly =
    zio.aws.appconfig.model.GetExtensionAssociationResponse
      .wrap(buildAwsValue())
}
object GetExtensionAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.GetExtensionAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.GetExtensionAssociationResponse =
      zio.aws.appconfig.model.GetExtensionAssociationResponse(
        id.map(value => value),
        extensionArn.map(value => value),
        resourceArn.map(value => value),
        arn.map(value => value),
        parameters.map(value => value),
        extensionVersionNumber.map(value => value)
      )
    def id: Optional[Identifier]
    def extensionArn: Optional[Arn]
    def resourceArn: Optional[Arn]
    def arn: Optional[Arn]
    def parameters: Optional[Map[Name, StringWithLengthBetween1And2048]]
    def extensionVersionNumber
        : Optional[zio.aws.appconfig.model.primitives.Integer]
    def getId: ZIO[Any, AwsError, Identifier] =
      AwsError.unwrapOptionField("id", id)
    def getExtensionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("extensionArn", extensionArn)
    def getResourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getParameters
        : ZIO[Any, AwsError, Map[Name, StringWithLengthBetween1And2048]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getExtensionVersionNumber
        : ZIO[Any, AwsError, zio.aws.appconfig.model.primitives.Integer] =
      AwsError.unwrapOptionField(
        "extensionVersionNumber",
        extensionVersionNumber
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.GetExtensionAssociationResponse
  ) extends zio.aws.appconfig.model.GetExtensionAssociationResponse.ReadOnly {
    override val id: Optional[Identifier] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.appconfig.model.primitives.Identifier(value))
    override val extensionArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.extensionArn())
      .map(value => zio.aws.appconfig.model.primitives.Arn(value))
    override val resourceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.appconfig.model.primitives.Arn(value))
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.appconfig.model.primitives.Arn(value))
    override val parameters
        : Optional[Map[Name, StringWithLengthBetween1And2048]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.appconfig.model.primitives
                .Name(key) -> zio.aws.appconfig.model.primitives
                .StringWithLengthBetween1And2048(value)
            })
            .toMap
        )
    override val extensionVersionNumber
        : Optional[zio.aws.appconfig.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extensionVersionNumber())
        .map(value => value: zio.aws.appconfig.model.primitives.Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.GetExtensionAssociationResponse
  ): zio.aws.appconfig.model.GetExtensionAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
