package zio.aws.appconfig.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.appconfig.model.primitives.Identifier
import scala.jdk.CollectionConverters.*
final case class GetExtensionRequest(
    extensionIdentifier: Identifier,
    versionNumber: Optional[zio.aws.appconfig.model.primitives.Integer] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.GetExtensionRequest = {
    import GetExtensionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.GetExtensionRequest
      .builder()
      .extensionIdentifier(
        Identifier.unwrap(extensionIdentifier): java.lang.String
      )
      .optionallyWith(versionNumber.map(value => value: Integer))(
        _.versionNumber
      )
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.GetExtensionRequest.ReadOnly =
    zio.aws.appconfig.model.GetExtensionRequest.wrap(buildAwsValue())
}
object GetExtensionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.GetExtensionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.GetExtensionRequest =
      zio.aws.appconfig.model.GetExtensionRequest(
        extensionIdentifier,
        versionNumber.map(value => value)
      )
    def extensionIdentifier: Identifier
    def versionNumber: Optional[zio.aws.appconfig.model.primitives.Integer]
    def getExtensionIdentifier: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(extensionIdentifier)
    def getVersionNumber
        : ZIO[Any, AwsError, zio.aws.appconfig.model.primitives.Integer] =
      AwsError.unwrapOptionField("versionNumber", versionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.GetExtensionRequest
  ) extends zio.aws.appconfig.model.GetExtensionRequest.ReadOnly {
    override val extensionIdentifier: Identifier =
      zio.aws.appconfig.model.primitives.Identifier(impl.extensionIdentifier())
    override val versionNumber
        : Optional[zio.aws.appconfig.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionNumber())
        .map(value => value: zio.aws.appconfig.model.primitives.Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.GetExtensionRequest
  ): zio.aws.appconfig.model.GetExtensionRequest.ReadOnly = new Wrapper(impl)
}
