package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.Description
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Parameter(
    description: Optional[Description] = Optional.Absent,
    required: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.Parameter = {
    import Parameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.Parameter
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(required.map(value => value: java.lang.Boolean))(
        _.required
      )
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.Parameter.ReadOnly =
    zio.aws.appconfig.model.Parameter.wrap(buildAwsValue())
}
object Parameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.Parameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.Parameter = zio.aws.appconfig.model
      .Parameter(description.map(value => value), required.map(value => value))
    def description: Optional[Description]
    def required: Optional[Boolean]
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("required", required)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.Parameter
  ) extends zio.aws.appconfig.model.Parameter.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val required: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.required())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.Parameter
  ): zio.aws.appconfig.model.Parameter.ReadOnly = new Wrapper(impl)
}
