package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{
  DeploymentStrategyId,
  Identifier,
  TagValue,
  Description,
  Version,
  Id,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartDeploymentRequest(
    applicationId: Id,
    environmentId: Id,
    deploymentStrategyId: DeploymentStrategyId,
    configurationProfileId: Id,
    configurationVersion: Version,
    description: Optional[Description] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    kmsKeyIdentifier: Optional[Identifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.StartDeploymentRequest = {
    import StartDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.StartDeploymentRequest
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .environmentId(Id.unwrap(environmentId): java.lang.String)
      .deploymentStrategyId(
        DeploymentStrategyId.unwrap(deploymentStrategyId): java.lang.String
      )
      .configurationProfileId(
        Id.unwrap(configurationProfileId): java.lang.String
      )
      .configurationVersion(
        Version.unwrap(configurationVersion): java.lang.String
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        kmsKeyIdentifier.map(value =>
          Identifier.unwrap(value): java.lang.String
        )
      )(_.kmsKeyIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.StartDeploymentRequest.ReadOnly =
    zio.aws.appconfig.model.StartDeploymentRequest.wrap(buildAwsValue())
}
object StartDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.StartDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.StartDeploymentRequest =
      zio.aws.appconfig.model.StartDeploymentRequest(
        applicationId,
        environmentId,
        deploymentStrategyId,
        configurationProfileId,
        configurationVersion,
        description.map(value => value),
        tags.map(value => value),
        kmsKeyIdentifier.map(value => value)
      )
    def applicationId: Id
    def environmentId: Id
    def deploymentStrategyId: DeploymentStrategyId
    def configurationProfileId: Id
    def configurationVersion: Version
    def description: Optional[Description]
    def tags: Optional[Map[TagKey, TagValue]]
    def kmsKeyIdentifier: Optional[Identifier]
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
    def getEnvironmentId: ZIO[Any, Nothing, Id] = ZIO.succeed(environmentId)
    def getDeploymentStrategyId: ZIO[Any, Nothing, DeploymentStrategyId] =
      ZIO.succeed(deploymentStrategyId)
    def getConfigurationProfileId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(configurationProfileId)
    def getConfigurationVersion: ZIO[Any, Nothing, Version] =
      ZIO.succeed(configurationVersion)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getKmsKeyIdentifier: ZIO[Any, AwsError, Identifier] =
      AwsError.unwrapOptionField("kmsKeyIdentifier", kmsKeyIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.StartDeploymentRequest
  ) extends zio.aws.appconfig.model.StartDeploymentRequest.ReadOnly {
    override val applicationId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.applicationId())
    override val environmentId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.environmentId())
    override val deploymentStrategyId: DeploymentStrategyId =
      zio.aws.appconfig.model.primitives
        .DeploymentStrategyId(impl.deploymentStrategyId())
    override val configurationProfileId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.configurationProfileId())
    override val configurationVersion: Version =
      zio.aws.appconfig.model.primitives.Version(impl.configurationVersion())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appconfig.model.primitives
              .TagKey(key) -> zio.aws.appconfig.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val kmsKeyIdentifier: Optional[Identifier] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyIdentifier())
      .map(value => zio.aws.appconfig.model.primitives.Identifier(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.StartDeploymentRequest
  ): zio.aws.appconfig.model.StartDeploymentRequest.ReadOnly = new Wrapper(impl)
}
