package zio.aws.appconfig.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.appconfig.model.primitives.{
  Identifier,
  Percentage,
  Uri,
  MinutesBetween0And24Hours,
  Arn,
  Iso8601DateTime,
  Description,
  Version,
  Name,
  Id
}
import scala.jdk.CollectionConverters.*
final case class StartDeploymentResponse(
    applicationId: Optional[Id] = Optional.Absent,
    environmentId: Optional[Id] = Optional.Absent,
    deploymentStrategyId: Optional[Id] = Optional.Absent,
    configurationProfileId: Optional[Id] = Optional.Absent,
    deploymentNumber: Optional[zio.aws.appconfig.model.primitives.Integer] =
      Optional.Absent,
    configurationName: Optional[Name] = Optional.Absent,
    configurationLocationUri: Optional[Uri] = Optional.Absent,
    configurationVersion: Optional[Version] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    deploymentDurationInMinutes: Optional[MinutesBetween0And24Hours] =
      Optional.Absent,
    growthType: Optional[zio.aws.appconfig.model.GrowthType] = Optional.Absent,
    growthFactor: Optional[Percentage] = Optional.Absent,
    finalBakeTimeInMinutes: Optional[MinutesBetween0And24Hours] =
      Optional.Absent,
    state: Optional[zio.aws.appconfig.model.DeploymentState] = Optional.Absent,
    eventLog: Optional[Iterable[zio.aws.appconfig.model.DeploymentEvent]] =
      Optional.Absent,
    percentageComplete: Optional[Percentage] = Optional.Absent,
    startedAt: Optional[Iso8601DateTime] = Optional.Absent,
    completedAt: Optional[Iso8601DateTime] = Optional.Absent,
    appliedExtensions: Optional[
      Iterable[zio.aws.appconfig.model.AppliedExtension]
    ] = Optional.Absent,
    kmsKeyArn: Optional[Arn] = Optional.Absent,
    kmsKeyIdentifier: Optional[Identifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.StartDeploymentResponse = {
    import StartDeploymentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.StartDeploymentResponse
      .builder()
      .optionallyWith(
        applicationId.map(value => Id.unwrap(value): java.lang.String)
      )(_.applicationId)
      .optionallyWith(
        environmentId.map(value => Id.unwrap(value): java.lang.String)
      )(_.environmentId)
      .optionallyWith(
        deploymentStrategyId.map(value => Id.unwrap(value): java.lang.String)
      )(_.deploymentStrategyId)
      .optionallyWith(
        configurationProfileId.map(value => Id.unwrap(value): java.lang.String)
      )(_.configurationProfileId)
      .optionallyWith(deploymentNumber.map(value => value: Integer))(
        _.deploymentNumber
      )
      .optionallyWith(
        configurationName.map(value => Name.unwrap(value): java.lang.String)
      )(_.configurationName)
      .optionallyWith(
        configurationLocationUri.map(value =>
          Uri.unwrap(value): java.lang.String
        )
      )(_.configurationLocationUri)
      .optionallyWith(
        configurationVersion.map(value =>
          Version.unwrap(value): java.lang.String
        )
      )(_.configurationVersion)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        deploymentDurationInMinutes.map(value =>
          MinutesBetween0And24Hours.unwrap(value): Integer
        )
      )(_.deploymentDurationInMinutes)
      .optionallyWith(growthType.map(value => value.unwrap))(_.growthType)
      .optionallyWith(
        growthFactor.map(value => Percentage.unwrap(value): java.lang.Float)
      )(_.growthFactor)
      .optionallyWith(
        finalBakeTimeInMinutes.map(value =>
          MinutesBetween0And24Hours.unwrap(value): Integer
        )
      )(_.finalBakeTimeInMinutes)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        eventLog.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventLog)
      .optionallyWith(
        percentageComplete.map(value =>
          Percentage.unwrap(value): java.lang.Float
        )
      )(_.percentageComplete)
      .optionallyWith(
        startedAt.map(value => Iso8601DateTime.unwrap(value): Instant)
      )(_.startedAt)
      .optionallyWith(
        completedAt.map(value => Iso8601DateTime.unwrap(value): Instant)
      )(_.completedAt)
      .optionallyWith(
        appliedExtensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.appliedExtensions)
      .optionallyWith(
        kmsKeyArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .optionallyWith(
        kmsKeyIdentifier.map(value =>
          Identifier.unwrap(value): java.lang.String
        )
      )(_.kmsKeyIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.StartDeploymentResponse.ReadOnly =
    zio.aws.appconfig.model.StartDeploymentResponse.wrap(buildAwsValue())
}
object StartDeploymentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.StartDeploymentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.StartDeploymentResponse =
      zio.aws.appconfig.model.StartDeploymentResponse(
        applicationId.map(value => value),
        environmentId.map(value => value),
        deploymentStrategyId.map(value => value),
        configurationProfileId.map(value => value),
        deploymentNumber.map(value => value),
        configurationName.map(value => value),
        configurationLocationUri.map(value => value),
        configurationVersion.map(value => value),
        description.map(value => value),
        deploymentDurationInMinutes.map(value => value),
        growthType.map(value => value),
        growthFactor.map(value => value),
        finalBakeTimeInMinutes.map(value => value),
        state.map(value => value),
        eventLog.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        percentageComplete.map(value => value),
        startedAt.map(value => value),
        completedAt.map(value => value),
        appliedExtensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsKeyArn.map(value => value),
        kmsKeyIdentifier.map(value => value)
      )
    def applicationId: Optional[Id]
    def environmentId: Optional[Id]
    def deploymentStrategyId: Optional[Id]
    def configurationProfileId: Optional[Id]
    def deploymentNumber: Optional[zio.aws.appconfig.model.primitives.Integer]
    def configurationName: Optional[Name]
    def configurationLocationUri: Optional[Uri]
    def configurationVersion: Optional[Version]
    def description: Optional[Description]
    def deploymentDurationInMinutes: Optional[MinutesBetween0And24Hours]
    def growthType: Optional[zio.aws.appconfig.model.GrowthType]
    def growthFactor: Optional[Percentage]
    def finalBakeTimeInMinutes: Optional[MinutesBetween0And24Hours]
    def state: Optional[zio.aws.appconfig.model.DeploymentState]
    def eventLog
        : Optional[List[zio.aws.appconfig.model.DeploymentEvent.ReadOnly]]
    def percentageComplete: Optional[Percentage]
    def startedAt: Optional[Iso8601DateTime]
    def completedAt: Optional[Iso8601DateTime]
    def appliedExtensions
        : Optional[List[zio.aws.appconfig.model.AppliedExtension.ReadOnly]]
    def kmsKeyArn: Optional[Arn]
    def kmsKeyIdentifier: Optional[Identifier]
    def getApplicationId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getEnvironmentId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getDeploymentStrategyId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("deploymentStrategyId", deploymentStrategyId)
    def getConfigurationProfileId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("configurationProfileId", configurationProfileId)
    def getDeploymentNumber
        : ZIO[Any, AwsError, zio.aws.appconfig.model.primitives.Integer] =
      AwsError.unwrapOptionField("deploymentNumber", deploymentNumber)
    def getConfigurationName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("configurationName", configurationName)
    def getConfigurationLocationUri: ZIO[Any, AwsError, Uri] = AwsError
      .unwrapOptionField("configurationLocationUri", configurationLocationUri)
    def getConfigurationVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("configurationVersion", configurationVersion)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDeploymentDurationInMinutes
        : ZIO[Any, AwsError, MinutesBetween0And24Hours] =
      AwsError.unwrapOptionField(
        "deploymentDurationInMinutes",
        deploymentDurationInMinutes
      )
    def getGrowthType: ZIO[Any, AwsError, zio.aws.appconfig.model.GrowthType] =
      AwsError.unwrapOptionField("growthType", growthType)
    def getGrowthFactor: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("growthFactor", growthFactor)
    def getFinalBakeTimeInMinutes
        : ZIO[Any, AwsError, MinutesBetween0And24Hours] = AwsError
      .unwrapOptionField("finalBakeTimeInMinutes", finalBakeTimeInMinutes)
    def getState: ZIO[Any, AwsError, zio.aws.appconfig.model.DeploymentState] =
      AwsError.unwrapOptionField("state", state)
    def getEventLog: ZIO[Any, AwsError, List[
      zio.aws.appconfig.model.DeploymentEvent.ReadOnly
    ]] = AwsError.unwrapOptionField("eventLog", eventLog)
    def getPercentageComplete: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("percentageComplete", percentageComplete)
    def getStartedAt: ZIO[Any, AwsError, Iso8601DateTime] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getCompletedAt: ZIO[Any, AwsError, Iso8601DateTime] =
      AwsError.unwrapOptionField("completedAt", completedAt)
    def getAppliedExtensions: ZIO[Any, AwsError, List[
      zio.aws.appconfig.model.AppliedExtension.ReadOnly
    ]] = AwsError.unwrapOptionField("appliedExtensions", appliedExtensions)
    def getKmsKeyArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getKmsKeyIdentifier: ZIO[Any, AwsError, Identifier] =
      AwsError.unwrapOptionField("kmsKeyIdentifier", kmsKeyIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.StartDeploymentResponse
  ) extends zio.aws.appconfig.model.StartDeploymentResponse.ReadOnly {
    override val applicationId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val environmentId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val deploymentStrategyId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentStrategyId())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val configurationProfileId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationProfileId())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val deploymentNumber
        : Optional[zio.aws.appconfig.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentNumber())
        .map(value => value: zio.aws.appconfig.model.primitives.Integer)
    override val configurationName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationName())
      .map(value => zio.aws.appconfig.model.primitives.Name(value))
    override val configurationLocationUri: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationLocationUri())
      .map(value => zio.aws.appconfig.model.primitives.Uri(value))
    override val configurationVersion: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationVersion())
      .map(value => zio.aws.appconfig.model.primitives.Version(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val deploymentDurationInMinutes
        : Optional[MinutesBetween0And24Hours] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentDurationInMinutes())
      .map(value =>
        zio.aws.appconfig.model.primitives.MinutesBetween0And24Hours(value)
      )
    override val growthType: Optional[zio.aws.appconfig.model.GrowthType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.growthType())
        .map(value => zio.aws.appconfig.model.GrowthType.wrap(value))
    override val growthFactor: Optional[Percentage] = zio.aws.core.internal
      .optionalFromNullable(impl.growthFactor())
      .map(value => zio.aws.appconfig.model.primitives.Percentage(value))
    override val finalBakeTimeInMinutes: Optional[MinutesBetween0And24Hours] =
      zio.aws.core.internal
        .optionalFromNullable(impl.finalBakeTimeInMinutes())
        .map(value =>
          zio.aws.appconfig.model.primitives.MinutesBetween0And24Hours(value)
        )
    override val state: Optional[zio.aws.appconfig.model.DeploymentState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.appconfig.model.DeploymentState.wrap(value))
    override val eventLog
        : Optional[List[zio.aws.appconfig.model.DeploymentEvent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventLog())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appconfig.model.DeploymentEvent.wrap(item)
          }.toList
        )
    override val percentageComplete: Optional[Percentage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.percentageComplete())
        .map(value => zio.aws.appconfig.model.primitives.Percentage(value))
    override val startedAt: Optional[Iso8601DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.appconfig.model.primitives.Iso8601DateTime(value))
    override val completedAt: Optional[Iso8601DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.completedAt())
      .map(value => zio.aws.appconfig.model.primitives.Iso8601DateTime(value))
    override val appliedExtensions
        : Optional[List[zio.aws.appconfig.model.AppliedExtension.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appliedExtensions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appconfig.model.AppliedExtension.wrap(item)
          }.toList
        )
    override val kmsKeyArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.appconfig.model.primitives.Arn(value))
    override val kmsKeyIdentifier: Optional[Identifier] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyIdentifier())
      .map(value => zio.aws.appconfig.model.primitives.Identifier(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.StartDeploymentResponse
  ): zio.aws.appconfig.model.StartDeploymentResponse.ReadOnly = new Wrapper(
    impl
  )
}
