package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{Description, Name, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateEnvironmentRequest(
    applicationId: Id,
    environmentId: Id,
    name: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    monitors: Optional[Iterable[zio.aws.appconfig.model.Monitor]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.UpdateEnvironmentRequest = {
    import UpdateEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.UpdateEnvironmentRequest
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .environmentId(Id.unwrap(environmentId): java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        monitors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.monitors)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.UpdateEnvironmentRequest.ReadOnly =
    zio.aws.appconfig.model.UpdateEnvironmentRequest.wrap(buildAwsValue())
}
object UpdateEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.UpdateEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.UpdateEnvironmentRequest =
      zio.aws.appconfig.model.UpdateEnvironmentRequest(
        applicationId,
        environmentId,
        name.map(value => value),
        description.map(value => value),
        monitors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def applicationId: Id
    def environmentId: Id
    def name: Optional[Name]
    def description: Optional[Description]
    def monitors: Optional[List[zio.aws.appconfig.model.Monitor.ReadOnly]]
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
    def getEnvironmentId: ZIO[Any, Nothing, Id] = ZIO.succeed(environmentId)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getMonitors
        : ZIO[Any, AwsError, List[zio.aws.appconfig.model.Monitor.ReadOnly]] =
      AwsError.unwrapOptionField("monitors", monitors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.UpdateEnvironmentRequest
  ) extends zio.aws.appconfig.model.UpdateEnvironmentRequest.ReadOnly {
    override val applicationId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.applicationId())
    override val environmentId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.environmentId())
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.appconfig.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val monitors
        : Optional[List[zio.aws.appconfig.model.Monitor.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appconfig.model.Monitor.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.UpdateEnvironmentRequest
  ): zio.aws.appconfig.model.UpdateEnvironmentRequest.ReadOnly = new Wrapper(
    impl
  )
}
