package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{
  StringWithLengthBetween1And2048,
  Name,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateExtensionAssociationRequest(
    extensionAssociationId: Id,
    parameters: Optional[Map[Name, StringWithLengthBetween1And2048]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.UpdateExtensionAssociationRequest = {
    import UpdateExtensionAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.UpdateExtensionAssociationRequest
      .builder()
      .extensionAssociationId(
        Id.unwrap(extensionAssociationId): java.lang.String
      )
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(
                key
              ): java.lang.String) -> (StringWithLengthBetween1And2048
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.UpdateExtensionAssociationRequest.ReadOnly =
    zio.aws.appconfig.model.UpdateExtensionAssociationRequest
      .wrap(buildAwsValue())
}
object UpdateExtensionAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.UpdateExtensionAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.UpdateExtensionAssociationRequest =
      zio.aws.appconfig.model.UpdateExtensionAssociationRequest(
        extensionAssociationId,
        parameters.map(value => value)
      )
    def extensionAssociationId: Id
    def parameters: Optional[Map[Name, StringWithLengthBetween1And2048]]
    def getExtensionAssociationId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(extensionAssociationId)
    def getParameters
        : ZIO[Any, AwsError, Map[Name, StringWithLengthBetween1And2048]] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.UpdateExtensionAssociationRequest
  ) extends zio.aws.appconfig.model.UpdateExtensionAssociationRequest.ReadOnly {
    override val extensionAssociationId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.extensionAssociationId())
    override val parameters
        : Optional[Map[Name, StringWithLengthBetween1And2048]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.appconfig.model.primitives
                .Name(key) -> zio.aws.appconfig.model.primitives
                .StringWithLengthBetween1And2048(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.UpdateExtensionAssociationRequest
  ): zio.aws.appconfig.model.UpdateExtensionAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
