package zio.aws.appconfig.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.appconfig.model.primitives.{Arn, Description, Name, Id}
import scala.jdk.CollectionConverters.*
final case class UpdateExtensionResponse(
    id: Optional[Id] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    versionNumber: Optional[zio.aws.appconfig.model.primitives.Integer] =
      Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    actions: Optional[Map[zio.aws.appconfig.model.ActionPoint, Iterable[
      zio.aws.appconfig.model.Action
    ]]] = Optional.Absent,
    parameters: Optional[Map[Name, zio.aws.appconfig.model.Parameter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.UpdateExtensionResponse = {
    import UpdateExtensionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.UpdateExtensionResponse
      .builder()
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(versionNumber.map(value => value: Integer))(
        _.versionNumber
      )
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        actions.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.map { item =>
                item.buildAwsValue()
              }.asJavaCollection
            })
            .asJava
        )
      )(_.actionsWithStrings)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.UpdateExtensionResponse.ReadOnly =
    zio.aws.appconfig.model.UpdateExtensionResponse.wrap(buildAwsValue())
}
object UpdateExtensionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.UpdateExtensionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.UpdateExtensionResponse =
      zio.aws.appconfig.model.UpdateExtensionResponse(
        id.map(value => value),
        name.map(value => value),
        versionNumber.map(value => value),
        arn.map(value => value),
        description.map(value => value),
        actions.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.asEditable
            }
          })
        ),
        parameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def id: Optional[Id]
    def name: Optional[Name]
    def versionNumber: Optional[zio.aws.appconfig.model.primitives.Integer]
    def arn: Optional[Arn]
    def description: Optional[Description]
    def actions: Optional[Map[zio.aws.appconfig.model.ActionPoint, List[
      zio.aws.appconfig.model.Action.ReadOnly
    ]]]
    def parameters
        : Optional[Map[Name, zio.aws.appconfig.model.Parameter.ReadOnly]]
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getVersionNumber
        : ZIO[Any, AwsError, zio.aws.appconfig.model.primitives.Integer] =
      AwsError.unwrapOptionField("versionNumber", versionNumber)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getActions
        : ZIO[Any, AwsError, Map[zio.aws.appconfig.model.ActionPoint, List[
          zio.aws.appconfig.model.Action.ReadOnly
        ]]] = AwsError.unwrapOptionField("actions", actions)
    def getParameters: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.appconfig.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.UpdateExtensionResponse
  ) extends zio.aws.appconfig.model.UpdateExtensionResponse.ReadOnly {
    override val id: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.appconfig.model.primitives.Name(value))
    override val versionNumber
        : Optional[zio.aws.appconfig.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionNumber())
        .map(value => value: zio.aws.appconfig.model.primitives.Integer)
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.appconfig.model.primitives.Arn(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val actions
        : Optional[Map[zio.aws.appconfig.model.ActionPoint, List[
          zio.aws.appconfig.model.Action.ReadOnly
        ]]] = zio.aws.core.internal
      .optionalFromNullable(impl.actions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appconfig.model.ActionPoint.wrap(key) -> value.asScala.map {
              item =>
                zio.aws.appconfig.model.Action.wrap(item)
            }.toList
          })
          .toMap
      )
    override val parameters
        : Optional[Map[Name, zio.aws.appconfig.model.Parameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.appconfig.model.primitives
                .Name(key) -> zio.aws.appconfig.model.Parameter.wrap(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.UpdateExtensionResponse
  ): zio.aws.appconfig.model.UpdateExtensionResponse.ReadOnly = new Wrapper(
    impl
  )
}
