package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{Arn, Uri, Description, Name}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Action(
    name: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    uri: Optional[Uri] = Optional.Absent,
    roleArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.Action = {
    import Action.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.Action
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(uri.map(value => Uri.unwrap(value): java.lang.String))(
        _.uri
      )
      .optionallyWith(
        roleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.Action.ReadOnly =
    zio.aws.appconfig.model.Action.wrap(buildAwsValue())
}
object Action {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appconfig.model.Action] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.Action =
      zio.aws.appconfig.model.Action(
        name.map(value => value),
        description.map(value => value),
        uri.map(value => value),
        roleArn.map(value => value)
      )
    def name: Optional[Name]
    def description: Optional[Description]
    def uri: Optional[Uri]
    def roleArn: Optional[Arn]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getUri: ZIO[Any, AwsError, Uri] = AwsError.unwrapOptionField("uri", uri)
    def getRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.Action
  ) extends zio.aws.appconfig.model.Action.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.appconfig.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val uri: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.uri())
      .map(value => zio.aws.appconfig.model.primitives.Uri(value))
    override val roleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.appconfig.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.Action
  ): zio.aws.appconfig.model.Action.ReadOnly = new Wrapper(impl)
}
