package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{Identifier, Uri, Arn, Name, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ActionInvocation(
    extensionIdentifier: Optional[Identifier] = Optional.Absent,
    actionName: Optional[Name] = Optional.Absent,
    uri: Optional[Uri] = Optional.Absent,
    roleArn: Optional[Arn] = Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent,
    errorCode: Optional[String] = Optional.Absent,
    invocationId: Optional[Id] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.ActionInvocation = {
    import ActionInvocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.ActionInvocation
      .builder()
      .optionallyWith(
        extensionIdentifier.map(value =>
          Identifier.unwrap(value): java.lang.String
        )
      )(_.extensionIdentifier)
      .optionallyWith(
        actionName.map(value => Name.unwrap(value): java.lang.String)
      )(_.actionName)
      .optionallyWith(uri.map(value => Uri.unwrap(value): java.lang.String))(
        _.uri
      )
      .optionallyWith(
        roleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(
        invocationId.map(value => Id.unwrap(value): java.lang.String)
      )(_.invocationId)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.ActionInvocation.ReadOnly =
    zio.aws.appconfig.model.ActionInvocation.wrap(buildAwsValue())
}
object ActionInvocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.ActionInvocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.ActionInvocation =
      zio.aws.appconfig.model.ActionInvocation(
        extensionIdentifier.map(value => value),
        actionName.map(value => value),
        uri.map(value => value),
        roleArn.map(value => value),
        errorMessage.map(value => value),
        errorCode.map(value => value),
        invocationId.map(value => value)
      )
    def extensionIdentifier: Optional[Identifier]
    def actionName: Optional[Name]
    def uri: Optional[Uri]
    def roleArn: Optional[Arn]
    def errorMessage: Optional[String]
    def errorCode: Optional[String]
    def invocationId: Optional[Id]
    def getExtensionIdentifier: ZIO[Any, AwsError, Identifier] =
      AwsError.unwrapOptionField("extensionIdentifier", extensionIdentifier)
    def getActionName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("actionName", actionName)
    def getUri: ZIO[Any, AwsError, Uri] = AwsError.unwrapOptionField("uri", uri)
    def getRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getInvocationId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("invocationId", invocationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.ActionInvocation
  ) extends zio.aws.appconfig.model.ActionInvocation.ReadOnly {
    override val extensionIdentifier: Optional[Identifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extensionIdentifier())
        .map(value => zio.aws.appconfig.model.primitives.Identifier(value))
    override val actionName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.actionName())
      .map(value => zio.aws.appconfig.model.primitives.Name(value))
    override val uri: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.uri())
      .map(value => zio.aws.appconfig.model.primitives.Uri(value))
    override val roleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.appconfig.model.primitives.Arn(value))
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
    override val errorCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => value: String)
    override val invocationId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.invocationId())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.ActionInvocation
  ): zio.aws.appconfig.model.ActionInvocation.ReadOnly = new Wrapper(impl)
}
