package zio.aws.appconfig.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.appconfig.model.primitives.{
  StringWithLengthBetween1And2048,
  Name,
  Id
}
import scala.jdk.CollectionConverters.*
final case class AppliedExtension(
    extensionId: Optional[Id] = Optional.Absent,
    extensionAssociationId: Optional[Id] = Optional.Absent,
    versionNumber: Optional[zio.aws.appconfig.model.primitives.Integer] =
      Optional.Absent,
    parameters: Optional[Map[Name, StringWithLengthBetween1And2048]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.AppliedExtension = {
    import AppliedExtension.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.AppliedExtension
      .builder()
      .optionallyWith(
        extensionId.map(value => Id.unwrap(value): java.lang.String)
      )(_.extensionId)
      .optionallyWith(
        extensionAssociationId.map(value => Id.unwrap(value): java.lang.String)
      )(_.extensionAssociationId)
      .optionallyWith(versionNumber.map(value => value: Integer))(
        _.versionNumber
      )
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(
                key
              ): java.lang.String) -> (StringWithLengthBetween1And2048
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.AppliedExtension.ReadOnly =
    zio.aws.appconfig.model.AppliedExtension.wrap(buildAwsValue())
}
object AppliedExtension {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.AppliedExtension
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.AppliedExtension =
      zio.aws.appconfig.model.AppliedExtension(
        extensionId.map(value => value),
        extensionAssociationId.map(value => value),
        versionNumber.map(value => value),
        parameters.map(value => value)
      )
    def extensionId: Optional[Id]
    def extensionAssociationId: Optional[Id]
    def versionNumber: Optional[zio.aws.appconfig.model.primitives.Integer]
    def parameters: Optional[Map[Name, StringWithLengthBetween1And2048]]
    def getExtensionId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("extensionId", extensionId)
    def getExtensionAssociationId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("extensionAssociationId", extensionAssociationId)
    def getVersionNumber
        : ZIO[Any, AwsError, zio.aws.appconfig.model.primitives.Integer] =
      AwsError.unwrapOptionField("versionNumber", versionNumber)
    def getParameters
        : ZIO[Any, AwsError, Map[Name, StringWithLengthBetween1And2048]] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.AppliedExtension
  ) extends zio.aws.appconfig.model.AppliedExtension.ReadOnly {
    override val extensionId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.extensionId())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val extensionAssociationId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.extensionAssociationId())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val versionNumber
        : Optional[zio.aws.appconfig.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionNumber())
        .map(value => value: zio.aws.appconfig.model.primitives.Integer)
    override val parameters
        : Optional[Map[Name, StringWithLengthBetween1And2048]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.appconfig.model.primitives
                .Name(key) -> zio.aws.appconfig.model.primitives
                .StringWithLengthBetween1And2048(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.AppliedExtension
  ): zio.aws.appconfig.model.AppliedExtension.ReadOnly = new Wrapper(impl)
}
