package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{
  ConfigurationProfileType,
  Uri,
  LongName,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConfigurationProfileSummary(
    applicationId: Optional[Id] = Optional.Absent,
    id: Optional[Id] = Optional.Absent,
    name: Optional[LongName] = Optional.Absent,
    locationUri: Optional[Uri] = Optional.Absent,
    validatorTypes: Optional[Iterable[zio.aws.appconfig.model.ValidatorType]] =
      Optional.Absent,
    `type`: Optional[ConfigurationProfileType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.ConfigurationProfileSummary = {
    import ConfigurationProfileSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.ConfigurationProfileSummary
      .builder()
      .optionallyWith(
        applicationId.map(value => Id.unwrap(value): java.lang.String)
      )(_.applicationId)
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        name.map(value => LongName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        locationUri.map(value => Uri.unwrap(value): java.lang.String)
      )(_.locationUri)
      .optionallyWith(
        validatorTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.validatorTypesWithStrings)
      .optionallyWith(
        `type`.map(value =>
          ConfigurationProfileType.unwrap(value): java.lang.String
        )
      )(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.ConfigurationProfileSummary.ReadOnly =
    zio.aws.appconfig.model.ConfigurationProfileSummary.wrap(buildAwsValue())
}
object ConfigurationProfileSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.ConfigurationProfileSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.ConfigurationProfileSummary =
      zio.aws.appconfig.model.ConfigurationProfileSummary(
        applicationId.map(value => value),
        id.map(value => value),
        name.map(value => value),
        locationUri.map(value => value),
        validatorTypes.map(value => value),
        `type`.map(value => value)
      )
    def applicationId: Optional[Id]
    def id: Optional[Id]
    def name: Optional[LongName]
    def locationUri: Optional[Uri]
    def validatorTypes: Optional[List[zio.aws.appconfig.model.ValidatorType]]
    def `type`: Optional[ConfigurationProfileType]
    def getApplicationId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, LongName] =
      AwsError.unwrapOptionField("name", name)
    def getLocationUri: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("locationUri", locationUri)
    def getValidatorTypes
        : ZIO[Any, AwsError, List[zio.aws.appconfig.model.ValidatorType]] =
      AwsError.unwrapOptionField("validatorTypes", validatorTypes)
    def getType: ZIO[Any, AwsError, ConfigurationProfileType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.ConfigurationProfileSummary
  ) extends zio.aws.appconfig.model.ConfigurationProfileSummary.ReadOnly {
    override val applicationId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val id: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val name: Optional[LongName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.appconfig.model.primitives.LongName(value))
    override val locationUri: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.locationUri())
      .map(value => zio.aws.appconfig.model.primitives.Uri(value))
    override val validatorTypes
        : Optional[List[zio.aws.appconfig.model.ValidatorType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validatorTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appconfig.model.ValidatorType.wrap(item)
          }.toList
        )
    override val `type`: Optional[ConfigurationProfileType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.appconfig.model.primitives.ConfigurationProfileType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.ConfigurationProfileSummary
  ): zio.aws.appconfig.model.ConfigurationProfileSummary.ReadOnly = new Wrapper(
    impl
  )
}
