package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{
  RoleArn,
  ConfigurationProfileType,
  TagValue,
  Uri,
  Description,
  LongName,
  Id,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateConfigurationProfileRequest(
    applicationId: Id,
    name: LongName,
    description: Optional[Description] = Optional.Absent,
    locationUri: Uri,
    retrievalRoleArn: Optional[RoleArn] = Optional.Absent,
    validators: Optional[Iterable[zio.aws.appconfig.model.Validator]] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    `type`: Optional[ConfigurationProfileType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.CreateConfigurationProfileRequest = {
    import CreateConfigurationProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.CreateConfigurationProfileRequest
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .name(LongName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .locationUri(Uri.unwrap(locationUri): java.lang.String)
      .optionallyWith(
        retrievalRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.retrievalRoleArn)
      .optionallyWith(
        validators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validators)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        `type`.map(value =>
          ConfigurationProfileType.unwrap(value): java.lang.String
        )
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.CreateConfigurationProfileRequest.ReadOnly =
    zio.aws.appconfig.model.CreateConfigurationProfileRequest
      .wrap(buildAwsValue())
}
object CreateConfigurationProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.CreateConfigurationProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.CreateConfigurationProfileRequest =
      zio.aws.appconfig.model.CreateConfigurationProfileRequest(
        applicationId,
        name,
        description.map(value => value),
        locationUri,
        retrievalRoleArn.map(value => value),
        validators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value),
        `type`.map(value => value)
      )
    def applicationId: Id
    def name: LongName
    def description: Optional[Description]
    def locationUri: Uri
    def retrievalRoleArn: Optional[RoleArn]
    def validators: Optional[List[zio.aws.appconfig.model.Validator.ReadOnly]]
    def tags: Optional[Map[TagKey, TagValue]]
    def `type`: Optional[ConfigurationProfileType]
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
    def getName: ZIO[Any, Nothing, LongName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLocationUri: ZIO[Any, Nothing, Uri] = ZIO.succeed(locationUri)
    def getRetrievalRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("retrievalRoleArn", retrievalRoleArn)
    def getValidators
        : ZIO[Any, AwsError, List[zio.aws.appconfig.model.Validator.ReadOnly]] =
      AwsError.unwrapOptionField("validators", validators)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, AwsError, ConfigurationProfileType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.CreateConfigurationProfileRequest
  ) extends zio.aws.appconfig.model.CreateConfigurationProfileRequest.ReadOnly {
    override val applicationId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.applicationId())
    override val name: LongName =
      zio.aws.appconfig.model.primitives.LongName(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val locationUri: Uri =
      zio.aws.appconfig.model.primitives.Uri(impl.locationUri())
    override val retrievalRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.retrievalRoleArn())
      .map(value => zio.aws.appconfig.model.primitives.RoleArn(value))
    override val validators
        : Optional[List[zio.aws.appconfig.model.Validator.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validators())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appconfig.model.Validator.wrap(item)
          }.toList
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appconfig.model.primitives
              .TagKey(key) -> zio.aws.appconfig.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val `type`: Optional[ConfigurationProfileType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.appconfig.model.primitives.ConfigurationProfileType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.CreateConfigurationProfileRequest
  ): zio.aws.appconfig.model.CreateConfigurationProfileRequest.ReadOnly =
    new Wrapper(impl)
}
