package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{
  RoleArn,
  ConfigurationProfileType,
  Uri,
  Description,
  LongName,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateConfigurationProfileResponse(
    applicationId: Optional[Id] = Optional.Absent,
    id: Optional[Id] = Optional.Absent,
    name: Optional[LongName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    locationUri: Optional[Uri] = Optional.Absent,
    retrievalRoleArn: Optional[RoleArn] = Optional.Absent,
    validators: Optional[Iterable[zio.aws.appconfig.model.Validator]] =
      Optional.Absent,
    `type`: Optional[ConfigurationProfileType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.CreateConfigurationProfileResponse = {
    import CreateConfigurationProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.CreateConfigurationProfileResponse
      .builder()
      .optionallyWith(
        applicationId.map(value => Id.unwrap(value): java.lang.String)
      )(_.applicationId)
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        name.map(value => LongName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        locationUri.map(value => Uri.unwrap(value): java.lang.String)
      )(_.locationUri)
      .optionallyWith(
        retrievalRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.retrievalRoleArn)
      .optionallyWith(
        validators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validators)
      .optionallyWith(
        `type`.map(value =>
          ConfigurationProfileType.unwrap(value): java.lang.String
        )
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.CreateConfigurationProfileResponse.ReadOnly =
    zio.aws.appconfig.model.CreateConfigurationProfileResponse
      .wrap(buildAwsValue())
}
object CreateConfigurationProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.CreateConfigurationProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.CreateConfigurationProfileResponse =
      zio.aws.appconfig.model.CreateConfigurationProfileResponse(
        applicationId.map(value => value),
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        locationUri.map(value => value),
        retrievalRoleArn.map(value => value),
        validators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        `type`.map(value => value)
      )
    def applicationId: Optional[Id]
    def id: Optional[Id]
    def name: Optional[LongName]
    def description: Optional[Description]
    def locationUri: Optional[Uri]
    def retrievalRoleArn: Optional[RoleArn]
    def validators: Optional[List[zio.aws.appconfig.model.Validator.ReadOnly]]
    def `type`: Optional[ConfigurationProfileType]
    def getApplicationId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, LongName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLocationUri: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("locationUri", locationUri)
    def getRetrievalRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("retrievalRoleArn", retrievalRoleArn)
    def getValidators
        : ZIO[Any, AwsError, List[zio.aws.appconfig.model.Validator.ReadOnly]] =
      AwsError.unwrapOptionField("validators", validators)
    def getType: ZIO[Any, AwsError, ConfigurationProfileType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.CreateConfigurationProfileResponse
  ) extends zio.aws.appconfig.model.CreateConfigurationProfileResponse.ReadOnly {
    override val applicationId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val id: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val name: Optional[LongName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.appconfig.model.primitives.LongName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val locationUri: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.locationUri())
      .map(value => zio.aws.appconfig.model.primitives.Uri(value))
    override val retrievalRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.retrievalRoleArn())
      .map(value => zio.aws.appconfig.model.primitives.RoleArn(value))
    override val validators
        : Optional[List[zio.aws.appconfig.model.Validator.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validators())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appconfig.model.Validator.wrap(item)
          }.toList
        )
    override val `type`: Optional[ConfigurationProfileType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.appconfig.model.primitives.ConfigurationProfileType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.CreateConfigurationProfileResponse
  ): zio.aws.appconfig.model.CreateConfigurationProfileResponse.ReadOnly =
    new Wrapper(impl)
}
