package zio.aws.appconfig.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.appconfig.model.primitives.{
  Identifier,
  TagValue,
  Name,
  StringWithLengthBetween1And2048,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class CreateExtensionAssociationRequest(
    extensionIdentifier: Identifier,
    extensionVersionNumber: Optional[
      zio.aws.appconfig.model.primitives.Integer
    ] = Optional.Absent,
    resourceIdentifier: Identifier,
    parameters: Optional[Map[Name, StringWithLengthBetween1And2048]] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.CreateExtensionAssociationRequest = {
    import CreateExtensionAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.CreateExtensionAssociationRequest
      .builder()
      .extensionIdentifier(
        Identifier.unwrap(extensionIdentifier): java.lang.String
      )
      .optionallyWith(extensionVersionNumber.map(value => value: Integer))(
        _.extensionVersionNumber
      )
      .resourceIdentifier(
        Identifier.unwrap(resourceIdentifier): java.lang.String
      )
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(
                key
              ): java.lang.String) -> (StringWithLengthBetween1And2048
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.CreateExtensionAssociationRequest.ReadOnly =
    zio.aws.appconfig.model.CreateExtensionAssociationRequest
      .wrap(buildAwsValue())
}
object CreateExtensionAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.CreateExtensionAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.CreateExtensionAssociationRequest =
      zio.aws.appconfig.model.CreateExtensionAssociationRequest(
        extensionIdentifier,
        extensionVersionNumber.map(value => value),
        resourceIdentifier,
        parameters.map(value => value),
        tags.map(value => value)
      )
    def extensionIdentifier: Identifier
    def extensionVersionNumber
        : Optional[zio.aws.appconfig.model.primitives.Integer]
    def resourceIdentifier: Identifier
    def parameters: Optional[Map[Name, StringWithLengthBetween1And2048]]
    def tags: Optional[Map[TagKey, TagValue]]
    def getExtensionIdentifier: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(extensionIdentifier)
    def getExtensionVersionNumber
        : ZIO[Any, AwsError, zio.aws.appconfig.model.primitives.Integer] =
      AwsError.unwrapOptionField(
        "extensionVersionNumber",
        extensionVersionNumber
      )
    def getResourceIdentifier: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(resourceIdentifier)
    def getParameters
        : ZIO[Any, AwsError, Map[Name, StringWithLengthBetween1And2048]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.CreateExtensionAssociationRequest
  ) extends zio.aws.appconfig.model.CreateExtensionAssociationRequest.ReadOnly {
    override val extensionIdentifier: Identifier =
      zio.aws.appconfig.model.primitives.Identifier(impl.extensionIdentifier())
    override val extensionVersionNumber
        : Optional[zio.aws.appconfig.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extensionVersionNumber())
        .map(value => value: zio.aws.appconfig.model.primitives.Integer)
    override val resourceIdentifier: Identifier =
      zio.aws.appconfig.model.primitives.Identifier(impl.resourceIdentifier())
    override val parameters
        : Optional[Map[Name, StringWithLengthBetween1And2048]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.appconfig.model.primitives
                .Name(key) -> zio.aws.appconfig.model.primitives
                .StringWithLengthBetween1And2048(value)
            })
            .toMap
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appconfig.model.primitives
              .TagKey(key) -> zio.aws.appconfig.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.CreateExtensionAssociationRequest
  ): zio.aws.appconfig.model.CreateExtensionAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
