package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteExtensionAssociationRequest(extensionAssociationId: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.DeleteExtensionAssociationRequest = {
    import DeleteExtensionAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.DeleteExtensionAssociationRequest
      .builder()
      .extensionAssociationId(
        Id.unwrap(extensionAssociationId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.DeleteExtensionAssociationRequest.ReadOnly =
    zio.aws.appconfig.model.DeleteExtensionAssociationRequest
      .wrap(buildAwsValue())
}
object DeleteExtensionAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.DeleteExtensionAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.DeleteExtensionAssociationRequest =
      zio.aws.appconfig.model
        .DeleteExtensionAssociationRequest(extensionAssociationId)
    def extensionAssociationId: Id
    def getExtensionAssociationId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(extensionAssociationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.DeleteExtensionAssociationRequest
  ) extends zio.aws.appconfig.model.DeleteExtensionAssociationRequest.ReadOnly {
    override val extensionAssociationId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.extensionAssociationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.DeleteExtensionAssociationRequest
  ): zio.aws.appconfig.model.DeleteExtensionAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
